/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.model;

import de.sambalmueslie.herold.DataModelChangeListener;
import de.sambalmueslie.herold.DataModelElement;
import de.sambalmueslie.herold.annotations.ChangeListener;
import de.sambalmueslie.herold.annotations.ImplementationType;
import de.sambalmueslie.herold.util.AnnotationSpy;
import java.util.Optional;

public class Metadata<T extends DataModelElement> {
    private final Class<T> elementType;
    private final Class<DataModelChangeListener<T>> genericListenerType;
    private Class<? extends T> implType;
    private Class<? extends DataModelChangeListener<? extends T>> specificListenerType;

    Metadata(Class<T> elementType) {
        this.elementType = elementType;
        this.genericListenerType = DataModelChangeListener.class;
    }

    public Class<? extends T> getElementImplType() {
        if (this.implType == null) {
            this.implType = this.getImplementationType();
        }
        return this.implType;
    }

    public Class<T> getElementType() {
        return this.elementType;
    }

    public Class<? extends DataModelChangeListener<? extends T>> getSpecificListenerType() {
        if (this.specificListenerType == null) {
            this.specificListenerType = this.getListenerType();
        }
        return this.specificListenerType;
    }

    private Class<? extends T> getImplementationType() {
        Optional<ImplementationType> result = AnnotationSpy.findAnnotation(this.elementType, ImplementationType.class);
        return result.isPresent() ? result.get().value() : this.elementType;
    }

    private Class<? extends DataModelChangeListener<? extends T>> getListenerType() {
        Optional<ChangeListener> result = AnnotationSpy.findAnnotation(this.elementType, ChangeListener.class);
        return result.isPresent() ? result.get().value() : this.genericListenerType;
    }
}

