/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.model;

import de.sambalmueslie.herold.DataModel;
import de.sambalmueslie.herold.DataModelElement;
import de.sambalmueslie.herold.model.LocalModel;
import de.sambalmueslie.herold.model.Metadata;
import de.sambalmueslie.herold.model.access.AccessController;
import de.sambalmueslie.herold.model.data.Model;
import de.sambalmueslie.herold.model.instance.ModelInstance;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ModelController<T extends DataModelElement> {
    private static Logger logger = LogManager.getLogger(ModelController.class);
    private final Map<Long, ModelInstance<T>> instances = new LinkedHashMap<Long, ModelInstance<T>>();
    private final Metadata<T> metadata;
    private LocalModel<T> model;

    ModelController(Metadata<T> metadata) {
        this.metadata = metadata;
    }

    Optional<DataModel<T>> createNewInstance(String operatorId) {
        logger.debug("Create new instance for type {}", this.metadata.getElementType());
        if (this.model == null) {
            this.createModel();
        }
        AccessController<T> accessController = new AccessController<T>(operatorId, this.model);
        ModelInstance<T> instance = new ModelInstance<T>(accessController);
        this.instances.put(instance.getId(), instance);
        return Optional.of(instance);
    }

    void dispose() {
        logger.debug("Dispose model {}", this.metadata.getElementType());
        this.removeAll();
    }

    boolean isUnused() {
        return this.instances.isEmpty();
    }

    void remove(DataModel<T> modelInstance) {
        if (!(modelInstance instanceof ModelInstance)) {
            return;
        }
        ModelInstance instance = (ModelInstance)modelInstance;
        long instanceId = instance.getId();
        if (!this.instances.containsKey(instanceId)) {
            return;
        }
        logger.debug("Remove instance for type {}", this.metadata.getElementType());
        this.instances.remove(instanceId);
        instance.dispose();
        if (this.isUnused()) {
            this.model.dispose();
            this.model = null;
        }
    }

    void removeAll() {
        logger.debug("Remove all model instances for type {}", this.metadata.getElementType());
        this.instances.values().forEach(ModelInstance::dispose);
        this.instances.clear();
        if (this.model == null) {
            return;
        }
        this.model.dispose();
        this.model = null;
    }

    private void createModel() {
        this.model = new Model<T>(this.metadata);
    }
}

