/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.model.access;

import de.sambalmueslie.herold.DataModelElement;
import de.sambalmueslie.herold.annotations.AllowedReader;
import de.sambalmueslie.herold.annotations.AllowedWriter;
import de.sambalmueslie.herold.exceptions.ReadAccessException;
import de.sambalmueslie.herold.exceptions.WriteAccessException;
import de.sambalmueslie.herold.model.LocalModel;
import de.sambalmueslie.herold.model.LocalModelFilter;
import de.sambalmueslie.herold.util.AnnotationSpy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AccessController<T extends DataModelElement>
extends LocalModelFilter<T> {
    private Set<String> allowedReaders;
    private Set<String> allowedWriters;
    private final String operatorId;

    public AccessController(String operatorId, LocalModel<T> model) {
        super(model);
        this.operatorId = operatorId;
        this.setup();
    }

    @Override
    public void add(long instanceId, T element) {
        if (this.isWriteRestricted()) {
            throw new WriteAccessException(this.operatorId, this.getElementType(), "Cannot add element");
        }
        this.getNext().add(instanceId, element);
    }

    @Override
    public boolean contains(long elementId) {
        if (this.isReadRestricted()) {
            throw new ReadAccessException(this.operatorId, this.getElementType(), "Cannot read");
        }
        return this.getNext().contains(elementId);
    }

    @Override
    public void dispose() {
        this.allowedReaders.clear();
        this.allowedWriters.clear();
        this.getNext().dispose();
    }

    @Override
    public Optional<T> get(long elementId) {
        if (this.isReadRestricted()) {
            throw new ReadAccessException(this.operatorId, this.getElementType(), "Cannot read");
        }
        return this.getNext().get(elementId);
    }

    @Override
    public Collection<T> getAll() {
        if (this.isReadRestricted()) {
            throw new ReadAccessException(this.operatorId, this.getElementType(), "Cannot read");
        }
        return this.getNext().getAll();
    }

    @Override
    public boolean isEmpty() {
        if (this.isReadRestricted()) {
            throw new ReadAccessException(this.operatorId, this.getElementType(), "Cannot read");
        }
        return this.getNext().isEmpty();
    }

    @Override
    public void remove(long instanceId, long elementId) {
        if (this.isWriteRestricted()) {
            throw new WriteAccessException(this.operatorId, this.getElementType(), "Cannot remove element");
        }
        this.getNext().remove(instanceId, elementId);
    }

    @Override
    public void remove(long instanceId, T element) {
        if (this.isWriteRestricted()) {
            throw new WriteAccessException(this.operatorId, this.getElementType(), "Cannot remove element");
        }
        this.getNext().remove(instanceId, element);
    }

    @Override
    public void removeAll(long instanceId) {
        if (this.isWriteRestricted()) {
            throw new WriteAccessException(this.operatorId, this.getElementType(), "Cannot remove all elements");
        }
        this.getNext().removeAll(instanceId);
    }

    @Override
    public int size() {
        if (this.isReadRestricted()) {
            throw new ReadAccessException(this.operatorId, this.getElementType(), "Cannot read");
        }
        return this.getNext().size();
    }

    @Override
    public Stream<T> stream() {
        if (this.isReadRestricted()) {
            throw new ReadAccessException(this.operatorId, this.getElementType(), "Cannot read");
        }
        return this.getNext().stream();
    }

    @Override
    public void update(long instanceId, T element) {
        if (this.isWriteRestricted()) {
            throw new WriteAccessException(this.operatorId, this.getElementType(), "Cannot update element");
        }
        this.getNext().update(instanceId, element);
    }

    Class<T> getElementType() {
        return this.getMetadata().getElementType();
    }

    private boolean isReadRestricted() {
        if (this.operatorId == null || this.operatorId.isEmpty()) {
            return false;
        }
        if (this.allowedReaders == null || this.allowedReaders.isEmpty()) {
            return false;
        }
        return !this.allowedReaders.contains(this.operatorId);
    }

    private boolean isWriteRestricted() {
        if (this.operatorId == null || this.operatorId.isEmpty()) {
            return false;
        }
        if (this.allowedWriters == null || this.allowedWriters.isEmpty()) {
            return false;
        }
        return !this.allowedWriters.contains(this.operatorId);
    }

    private void setup() {
        Optional<AllowedWriter> writer;
        Optional<AllowedReader> reader = AnnotationSpy.findAnnotation(this.getElementType(), AllowedReader.class);
        if (reader.isPresent()) {
            this.allowedReaders = Arrays.stream(reader.get().value()).collect(Collectors.toSet());
        }
        if ((writer = AnnotationSpy.findAnnotation(this.getElementType(), AllowedWriter.class)).isPresent()) {
            this.allowedWriters = Arrays.stream(writer.get().value()).collect(Collectors.toSet());
        }
    }
}

