/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.model.data;

import de.sambalmueslie.herold.DataModelElement;
import de.sambalmueslie.herold.model.Metadata;
import de.sambalmueslie.herold.model.data.ElementCache;
import de.sambalmueslie.herold.model.data.ListenerMgr;
import de.sambalmueslie.herold.model.parse.Element;
import de.sambalmueslie.herold.model.parse.ElementConverter;
import de.sambalmueslie.herold.model.parse.JsonConverter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DataMgr<T extends DataModelElement> {
    private static Logger logger = LogManager.getLogger(DataMgr.class);
    private final ElementConverter<T> converter;
    private final Map<Long, T> data = new LinkedHashMap<Long, T>();
    private final Map<Long, T> dataCache = new LinkedHashMap<Long, T>();
    private final ElementCache elementCache = new ElementCache();
    private final Class<? extends T> elementImplType;
    private final Map<String, Field> fieldCache = new HashMap<String, Field>();
    private final ListenerMgr<T> listenerMgr;

    DataMgr(Metadata<T> metadata, ListenerMgr<T> listenerMgr) {
        this.elementImplType = metadata.getElementImplType();
        this.converter = new JsonConverter<T>(this.elementImplType);
        this.listenerMgr = listenerMgr;
    }

    void clear() {
        this.data.clear();
        this.elementCache.clear();
        this.dataCache.clear();
    }

    boolean contains(long elementId) {
        return this.data.containsKey(elementId);
    }

    Optional<T> get(long elementId) {
        DataModelElement element = (DataModelElement)this.data.get(elementId);
        return Optional.ofNullable(element);
    }

    Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    void insert(long instanceId, T element) {
        if (element == null) {
            logger.error("Cannot local add/update null element");
            return;
        }
        long elementId = element.getId();
        if (!this.data.containsKey(elementId)) {
            this.handleInsertAdd(instanceId, element);
        } else {
            this.handleInsertUpdate(instanceId, element);
        }
    }

    boolean isEmpty() {
        return this.data.isEmpty();
    }

    void remove(long instanceId, T element) {
        if (element == null) {
            logger.error("Cannot local remove null element");
            return;
        }
        long elementId = element.getId();
        this.data.remove(elementId);
        this.elementCache.remove(elementId);
        this.dataCache.remove(elementId);
        this.listenerMgr.notifyElementRemoved(instanceId, element);
    }

    int size() {
        return this.data.size();
    }

    Stream<T> stream() {
        return this.data.values().stream();
    }

    private Map<String, Object> getChanges(long elementId, Element diff) {
        DataModelElement former = (DataModelElement)this.dataCache.get(elementId);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> e : diff.getValues().entrySet()) {
            String fieldName = e.getKey();
            Field f = this.fieldCache.get(fieldName);
            if (f == null) {
                try {
                    f = this.elementImplType.getDeclaredField(fieldName);
                    f.setAccessible(true);
                    this.fieldCache.put(fieldName, f);
                }
                catch (NoSuchFieldException | SecurityException e1) {
                    logger.error("Cannot find field for change " + fieldName + " on type " + this.elementImplType, e);
                    continue;
                }
            }
            try {
                Object formerValue = f.get(former);
                result.put(fieldName, formerValue);
            }
            catch (IllegalAccessException | IllegalArgumentException e1) {
                logger.error("Cannot get field for change " + fieldName + " on type " + this.elementImplType, e);
            }
        }
        return result;
    }

    private Element getDiff(Optional<Element> current, Optional<Element> former) {
        if (!current.isPresent() && !former.isPresent()) {
            return new Element();
        }
        if (current.isPresent() && !former.isPresent()) {
            return current.get();
        }
        if (!current.isPresent() && former.isPresent()) {
            return former.get();
        }
        Element element = new Element(current.get().getId());
        Element f = former.get();
        Element c = current.get();
        c.getValues().entrySet().stream().filter(e -> f.contains((String)e.getKey())).filter(e -> !StringUtils.equals((CharSequence)f.get((String)e.getKey()).get(), (CharSequence)((CharSequence)e.getValue()))).forEach(e -> element.set((String)e.getKey(), f.get((String)e.getKey()).get()));
        f.getValues().entrySet().stream().filter(e -> !element.contains((String)e.getKey())).filter(e -> !c.contains((String)e.getKey())).forEach(e -> element.set((String)e.getKey(), f.get((String)e.getKey()).get()));
        return element;
    }

    private void handleInsertAdd(long instanceId, T element) {
        logger.debug("Insert new element {}", element);
        this.data.put(element.getId(), element);
        this.dataCache.put(element.getId(), element);
        Optional<Element> current = this.converter.convert(element);
        current.ifPresent(this.elementCache::update);
        this.updateDataCache(current);
        this.listenerMgr.notifyElementAdded(instanceId, element);
    }

    private void handleInsertUpdate(long instanceId, T element) {
        logger.debug("Update existing element {}", element);
        long elementId = element.getId();
        Optional<Element> former = this.elementCache.get(elementId);
        Optional<Element> current = this.converter.convert(element);
        Element diff = this.getDiff(current, former);
        if (diff.getValues().isEmpty()) {
            return;
        }
        current.ifPresent(this.elementCache::update);
        Map<String, Object> changes = this.getChanges(elementId, diff);
        this.updateDataCache(current);
        this.listenerMgr.notifyElementUpdated(instanceId, element, changes);
    }

    private void updateDataCache(Optional<Element> content) {
        if (!content.isPresent()) {
            return;
        }
        Element element = content.get();
        long elementId = element.getId();
        Optional<Element> obj = this.converter.convert(element);
        obj.ifPresent(o -> this.dataCache.put(elementId, o));
    }
}

