/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.model.data;

import de.sambalmueslie.herold.DataModelChangeListener;
import de.sambalmueslie.herold.DataModelElement;
import de.sambalmueslie.herold.annotations.Value;
import de.sambalmueslie.herold.model.Metadata;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ListenerMgr<T extends DataModelElement> {
    private static Logger logger = LogManager.getLogger(ListenerMgr.class);
    private final Map<String, Method> changeMethods = new HashMap<String, Method>();
    private final Class<? extends T> elementImplType;
    private final Class<T> elementType;
    private final Map<Long, Instance> instances = new HashMap<Long, Instance>();
    private final Class<?> specificListenerType;

    ListenerMgr(Metadata<T> metadata) {
        this.specificListenerType = metadata.getSpecificListenerType();
        this.elementType = metadata.getElementType();
        this.elementImplType = metadata.getElementImplType();
        this.setup();
    }

    void dispose() {
        this.instances.clear();
    }

    void notifyElementAdded(long instanceId, T element) {
        this.instances.entrySet().stream().filter(e -> (Long)e.getKey() != instanceId).map(Map.Entry::getValue).forEach(e -> e.notifyElementAdded(element));
    }

    void notifyElementRemoved(long instanceId, T element) {
        this.instances.entrySet().stream().filter(e -> (Long)e.getKey() != instanceId).map(Map.Entry::getValue).forEach(e -> e.notifyElementRemoved(element));
    }

    void notifyElementUpdated(long instanceId, T element, Map<String, Object> formerValues) {
        this.instances.entrySet().stream().filter(e -> (Long)e.getKey() != instanceId).map(Map.Entry::getValue).forEach(e -> e.notifyElementChanged(element, formerValues));
    }

    void register(long instanceId, DataModelChangeListener<T> listener) {
        Instance instance = this.instances.get(instanceId);
        if (instance == null) {
            instance = new Instance();
            this.instances.put(instanceId, instance);
        }
        instance.register(listener);
    }

    void unregister(long instanceId, DataModelChangeListener<T> listener) {
        Instance instance = this.instances.get(instanceId);
        if (instance == null) {
            return;
        }
        instance.unregister(listener);
        if (instance.genericListeners.isEmpty()) {
            this.instances.remove(instanceId);
        }
    }

    void unregisterAll(long instanceId) {
        Instance instance = this.instances.remove(instanceId);
        if (instance == null) {
            return;
        }
        instance.dispose();
    }

    private void setup() {
        for (Field f : this.elementImplType.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Value.class)) continue;
            String fieldName = f.getName();
            String methodName = "handle" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1) + "Changed";
            try {
                Method m = this.specificListenerType.getMethod(methodName, this.elementType, f.getType());
                this.changeMethods.put(fieldName, m);
            }
            catch (NoSuchMethodException | SecurityException e) {
                logger.warn("Cannot find change method " + methodName + " for " + fieldName, (Throwable)e);
            }
        }
    }

    private class Instance {
        private final Set<DataModelChangeListener<T>> genericListeners = new LinkedHashSet();
        private final Set<DataModelChangeListener<T>> specificListeners = new LinkedHashSet();

        private Instance() {
        }

        public void notifyElementAdded(T element) {
            this.genericListeners.stream().forEach(l -> l.handleElementAdded(element));
            this.specificListeners.stream().forEach(l -> l.handleElementAdded(element));
        }

        public void notifyElementChanged(T element, Map<String, Object> formerValues) {
            this.genericListeners.stream().forEach(l -> l.handleElementChanged(element));
            int specificUpdates = 0;
            for (Map.Entry<String, Object> e : formerValues.entrySet()) {
                Method m = (Method)ListenerMgr.this.changeMethods.get(e.getKey());
                if (m == null) continue;
                ++specificUpdates;
                this.specificListeners.stream().forEach(l -> {
                    try {
                        m.invoke(l, element, e.getValue());
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        // empty catch block
                    }
                });
            }
            if (specificUpdates <= 0 || specificUpdates != formerValues.size()) {
                this.specificListeners.stream().forEach(l -> l.handleElementChanged(element));
            }
        }

        public void notifyElementRemoved(T element) {
            this.genericListeners.stream().forEach(l -> l.handleElementRemoved(element));
            this.specificListeners.stream().forEach(l -> l.handleElementRemoved(element));
        }

        void dispose() {
            this.genericListeners.clear();
            this.specificListeners.clear();
        }

        void register(DataModelChangeListener<T> listener) {
            if (listener == null) {
                return;
            }
            if (this.isSpecificListener(listener)) {
                this.specificListeners.add(listener);
            } else {
                this.genericListeners.add(listener);
            }
        }

        void unregister(DataModelChangeListener<T> listener) {
            if (listener == null) {
                return;
            }
            this.genericListeners.remove(listener);
        }

        private boolean isSpecificListener(DataModelChangeListener<T> listener) {
            return ListenerMgr.this.specificListenerType.isAssignableFrom(listener.getClass());
        }
    }
}

