/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.model.data;

import de.sambalmueslie.herold.DataModelChangeListener;
import de.sambalmueslie.herold.DataModelElement;
import de.sambalmueslie.herold.model.LocalModel;
import de.sambalmueslie.herold.model.Metadata;
import de.sambalmueslie.herold.model.data.DataMgr;
import de.sambalmueslie.herold.model.data.ListenerMgr;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Model<T extends DataModelElement>
implements LocalModel<T> {
    private static Logger logger = LogManager.getLogger(Model.class);
    private final DataMgr<T> dataMgr;
    private final ListenerMgr<T> listenerMgr;
    private final Metadata<T> metadata;

    public Model(Metadata<T> metadata) {
        this.metadata = metadata;
        this.listenerMgr = new ListenerMgr<T>(metadata);
        this.dataMgr = new DataMgr<T>(metadata, this.listenerMgr);
    }

    @Override
    public void add(long instanceId, T element) {
        this.dataMgr.insert(instanceId, element);
    }

    @Override
    public boolean contains(long elementId) {
        return this.dataMgr.contains(elementId);
    }

    @Override
    public void dispose() {
        this.dataMgr.clear();
        this.listenerMgr.dispose();
    }

    @Override
    public Optional<T> get(long elementId) {
        return this.dataMgr.get(elementId);
    }

    @Override
    public Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.dataMgr.getAll());
    }

    @Override
    public Metadata<T> getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isEmpty() {
        return this.dataMgr.isEmpty();
    }

    @Override
    public void register(long instanceId, DataModelChangeListener<T> listener) {
        this.listenerMgr.register(instanceId, listener);
    }

    @Override
    public void remove(long instanceId, long elementId) {
        Optional<DataModelElement> element = this.dataMgr.get(elementId);
        element.ifPresent(e -> this.remove(instanceId, e));
    }

    @Override
    public void remove(long instanceId, T element) {
        this.dataMgr.remove(instanceId, element);
        if (element == null) {
            logger.error("Cannot local remove null element");
            return;
        }
        this.remove(instanceId, element.getId());
    }

    @Override
    public void removeAll(long instanceId) {
        LinkedHashSet<DataModelElement> copy = new LinkedHashSet<DataModelElement>(this.dataMgr.getAll());
        copy.forEach(e -> this.remove(instanceId, e));
    }

    @Override
    public int size() {
        return this.dataMgr.size();
    }

    @Override
    public Stream<T> stream() {
        return this.dataMgr.stream();
    }

    @Override
    public void unregister(long instanceId, DataModelChangeListener<T> listener) {
        this.listenerMgr.unregister(instanceId, listener);
    }

    @Override
    public void unregisterAll(long instanceId) {
        this.listenerMgr.unregisterAll(instanceId);
    }

    @Override
    public void update(long instanceId, T element) {
        this.dataMgr.insert(instanceId, element);
    }
}

