/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.model.instance;

import de.sambalmueslie.herold.DataModel;
import de.sambalmueslie.herold.DataModelChangeListener;
import de.sambalmueslie.herold.DataModelElement;
import de.sambalmueslie.herold.model.LocalModel;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class ModelInstance<T extends DataModelElement>
implements DataModel<T> {
    private final long instanceId;
    private final LocalModel<T> model;

    public ModelInstance(LocalModel<T> model) {
        this.model = model;
        this.instanceId = UUID.randomUUID().getLeastSignificantBits();
    }

    @Override
    public void add(T element) {
        this.model.add(this.instanceId, element);
    }

    @Override
    public boolean contains(long elementId) {
        return this.model.contains(elementId);
    }

    public void dispose() {
        this.model.unregisterAll(this.instanceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelInstance other = (ModelInstance)obj;
        return this.instanceId == other.instanceId;
    }

    @Override
    public Optional<T> get(long elementId) {
        return this.model.get(elementId);
    }

    @Override
    public Collection<T> getAll() {
        return this.model.getAll();
    }

    public long getId() {
        return this.instanceId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.instanceId ^ this.instanceId >>> 32);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    @Override
    public void register(DataModelChangeListener<T> listener) {
        this.model.register(this.instanceId, listener);
    }

    @Override
    public void remove(long elementId) {
        this.model.remove(this.instanceId, elementId);
    }

    @Override
    public void remove(T element) {
        this.model.remove(this.instanceId, element);
    }

    @Override
    public void removeAll() {
        this.model.removeAll(this.instanceId);
    }

    @Override
    public int size() {
        return this.model.size();
    }

    @Override
    public Stream<T> stream() {
        return this.model.stream();
    }

    @Override
    public void unregister(DataModelChangeListener<T> listener) {
        this.model.unregister(this.instanceId, listener);
    }

    @Override
    public void update(T element) {
        this.model.update(this.instanceId, element);
    }
}

