/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.model.parse;

import de.sambalmueslie.herold.DataModelElement;
import de.sambalmueslie.herold.annotations.Key;
import de.sambalmueslie.herold.annotations.Value;
import de.sambalmueslie.herold.model.parse.Element;
import de.sambalmueslie.herold.model.parse.ElementConverter;
import de.sambalmueslie.herold.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseConverter<T extends DataModelElement>
implements ElementConverter<T> {
    private static Logger logger = LogManager.getLogger(BaseConverter.class);
    private final Class<? extends T> elementType;
    private final Map<String, Field> fields;
    private final Field key;

    protected BaseConverter(Class<? extends T> elementType) {
        this.elementType = elementType;
        Set<Field> elementFields = ReflectionUtils.getFields(elementType);
        this.key = elementFields.stream().filter(f -> f.isAnnotationPresent(Key.class)).findAny().get();
        this.key.setAccessible(true);
        this.fields = elementFields.stream().filter(f -> f.isAnnotationPresent(Value.class)).collect(Collectors.toMap(Field::getName, Function.identity()));
        this.fields.values().forEach(f -> f.setAccessible(true));
    }

    @Override
    public final Optional<T> convert(Element element) {
        if (element == null) {
            return Optional.empty();
        }
        try {
            long id = element.getId();
            DataModelElement obj = (DataModelElement)this.elementType.newInstance();
            this.key.set(obj, id);
            return this.merge(element, obj);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Cannot create object for type " + this.elementType, (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public final Optional<Element> convert(T obj) {
        if (obj == null) {
            return Optional.empty();
        }
        long key = obj.getId();
        Element element = new Element(key);
        for (Field f : this.fields.values()) {
            try {
                Object fieldVal = f.get(obj);
                String value = this.objToString(fieldVal);
                element.set(f.getName(), value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                logger.error("cannot convert " + obj, (Throwable)e);
            }
        }
        return Optional.of(element);
    }

    @Override
    public final Optional<T> merge(Element element, T obj) {
        if (obj.getId() != element.getId()) {
            logger.error("Cannot merge element with id {} and obj with id {}", (Object)element.getId(), (Object)obj.getId());
            return Optional.empty();
        }
        try {
            for (Map.Entry<String, String> val : element.getValues().entrySet()) {
                String name = val.getKey();
                Field f = this.fields.get(name);
                if (f == null) {
                    logger.warn("Ignoring value {} for type {} cause no suitable field was found", (Object)name, this.elementType);
                    continue;
                }
                String value = val.getValue();
                Object fieldVal = this.stringToObj(value, f.getType());
                f.set(obj, fieldVal);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error("Cannot merge object for type " + this.elementType, (Throwable)e);
        }
        return Optional.of(obj);
    }

    protected abstract String objToString(Object var1);

    protected abstract Object stringToObj(String var1, Class<?> var2);
}

