/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.util;

import java.lang.annotation.Annotation;
import java.util.Optional;

public class AnnotationSpy {
    public static <A extends Annotation> Optional<A> findAnnotation(Class<?> type, Class<A> annotation) {
        if (type == null || annotation == null) {
            return Optional.empty();
        }
        A result = type.getAnnotation(annotation);
        if (result != null) {
            return Optional.of(result);
        }
        Optional<A> sResult = AnnotationSpy.findAnnotation(type.getSuperclass(), annotation);
        if (sResult.isPresent()) {
            return sResult;
        }
        for (Class<?> i : type.getInterfaces()) {
            Optional<A> ifResult = AnnotationSpy.findAnnotation(i, annotation);
            if (!ifResult.isPresent()) continue;
            return ifResult;
        }
        return Optional.empty();
    }

    private AnnotationSpy() {
    }
}

