/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.mdrclient;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.samply.common.mdrclient.CacheKey;
import de.samply.common.mdrclient.MdrClient;
import de.samply.common.mdrclient.MdrConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheManager {
    private static final int CACHE_MAXIMUM_SIZE = 10000;
    private static LoadingCache<CacheKey, String> jsonCache;
    private static Logger logger;

    private CacheManager() {
    }

    public static LoadingCache<CacheKey, String> getCache(final MdrClient mdrClient) {
        if (jsonCache == null) {
            CacheLoader<CacheKey, String> loader = new CacheLoader<CacheKey, String>(){

                public String load(CacheKey key) throws MdrConnectionException {
                    logger.debug("Element was not in cache: " + key.getPath() + " | " + key.getLanguageCode() + " | " + key.getAccessToken());
                    if (key.getAccessToken() != null) {
                        return mdrClient.getJsonFromMdr(key.getPath(), key.getLanguageCode(), key.getAccessToken());
                    }
                    return mdrClient.getJsonFromMdr(key.getPath(), key.getLanguageCode());
                }
            };
            jsonCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)loader);
        }
        return jsonCache;
    }

    public static void cleanCache(MdrClient mdrClient) {
        CacheManager.getCache(mdrClient).invalidateAll();
        logger.debug("Cache cleaned.");
    }

    static {
        logger = LoggerFactory.getLogger((String)CacheManager.class.getName());
    }
}

