/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.mdrclient;

import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.Base64;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory
implements HttpUrlConnectorProvider.ConnectionFactory {
    private Proxy proxy;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyRealm;
    private String username;
    private String password;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ConnectionFactory() {
    }

    public ConnectionFactory(String proxyHost, Integer proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public final String getProxyHost() {
        return this.proxyHost;
    }

    public final void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public final Integer getProxyPort() {
        return this.proxyPort;
    }

    public final void setProxyPort(String proxyPort) {
        if (proxyPort == null) {
            this.proxyPort = null;
            return;
        }
        Integer port = null;
        try {
            port = Integer.parseInt(proxyPort);
        }
        catch (NumberFormatException e) {
            port = null;
        }
        this.proxyPort = port;
    }

    public final String getProxyRealm() {
        return this.proxyRealm;
    }

    public final void setProxyRealm(String proxyRealm) {
        this.proxyRealm = proxyRealm;
    }

    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection con;
        String protocol = url.getProtocol();
        String encoded = null;
        if (this.proxyPort != null && protocol.equals("http")) {
            this.logger.debug("getting HTTP connection with proxystuff " + this.proxyHost + ":" + this.proxyPort);
            this.initializeProxy();
            if (this.username != null) {
                encoded = this.injectProxyLogin(this.username, this.password);
            }
        }
        if (this.proxy != null) {
            con = (HttpURLConnection)url.openConnection(this.proxy);
            if (encoded != null) {
                this.logger.debug("setting Proxy-Authorization: Basic " + encoded);
                con.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                if (this.proxyRealm != null && this.proxyRealm.length() > 0) {
                    this.logger.debug("setting Proxy-Authenticate: Basic realm=" + this.proxyRealm);
                    con.setRequestProperty("Proxy-Authenticate", "Basic realm=\"" + this.proxyRealm + "\"");
                }
            }
        } else {
            con = (HttpURLConnection)url.openConnection();
        }
        return con;
    }

    private void initializeProxy() {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort));
    }

    private String injectProxyLogin(final String username, final String password) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password.toCharArray());
            }
        });
        return new String(Base64.getEncoder().encode(new String(username + ":" + password).getBytes()));
    }
}

