/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.mdrclient;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.samply.common.mdrclient.CacheKey;
import de.samply.common.mdrclient.CacheManager;
import de.samply.common.mdrclient.ConnectionFactory;
import de.samply.common.mdrclient.MdrConnectionException;
import de.samply.common.mdrclient.MdrInvalidResponseException;
import de.samply.common.mdrclient.MdrProperties;
import de.samply.common.mdrclient.domain.Catalogue;
import de.samply.common.mdrclient.domain.Code;
import de.samply.common.mdrclient.domain.DataElement;
import de.samply.common.mdrclient.domain.Definition;
import de.samply.common.mdrclient.domain.EnumElementType;
import de.samply.common.mdrclient.domain.Label;
import de.samply.common.mdrclient.domain.Namespace;
import de.samply.common.mdrclient.domain.RecordDefinition;
import de.samply.common.mdrclient.domain.Result;
import de.samply.common.mdrclient.domain.ResultList;
import de.samply.common.mdrclient.domain.Slot;
import de.samply.common.mdrclient.domain.Validations;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdrClient {
    public static final String PATH_SEPARATOR = "/";
    private static final String MDR_URL = MdrProperties.getString("MdrClient.url");
    private static final String MDR_PROXY_PORT = MdrProperties.getString("MdrClient.proxy.port");
    private static final String MDR_PROXY_IP = MdrProperties.getString("MdrClient.proxy.ip");
    private static final String HTTP_PROXY_PORT_PROPERTY = "http.proxyPort";
    private static final String HTTP_PROXY_HOST_PROPERTY = "http.proxyHost";
    private static final String NAMESPACES_PATH = "namespaces";
    private static final String DATA_ELEMENTS_PATH = "dataelements";
    private static final String VALIDATIONS_PATH = "validations";
    private static final String CATALOGUE_PATH = "catalog";
    private static final String CATALOGUES_PATH = "catalogs";
    private static final String CODES_PATH = "codes";
    private static final String DESIGNATION_PATH = "uimodel";
    private static final String MEMBERS = "members";
    private static final String DATAELEMENTGROUPS = "dataelementgroups";
    private static final String RECORDS = "records";
    private static final String LABELS = "labels";
    private static final String SEARCH = "search";
    private static final String SEARCH_LOCAL = "local";
    private static final String SLOTS = "slots";
    private static final String REPRESENTATIONS = "representations";
    private static final String STATUS_RELEASED = "released";
    private static final String TYPE_DATAELEMENT = "dataelement";
    private static final String TYPE_DATAELEMENTGROUP = "dataelementgroup";
    private static Logger logger = LoggerFactory.getLogger((String)MdrClient.class.getName());
    private String mdrBaseUrl;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyRealm;
    private Client jerseyClient = null;

    public MdrClient() {
        this(MDR_URL, MDR_PROXY_IP, MDR_PROXY_PORT);
    }

    public MdrClient(String mdrBaseUrl) {
        this(mdrBaseUrl, null, null);
    }

    public MdrClient(String mdrBaseUrl, String proxyHost, String proxyPort) {
        if (proxyHost != null && proxyPort != null) {
            this.setProxy(proxyHost, proxyPort);
        }
        this.mdrBaseUrl = mdrBaseUrl;
    }

    public MdrClient(String mdrBaseUrl, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword) {
        this.mdrBaseUrl = mdrBaseUrl;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    public MdrClient(String mdrBaseUrl, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String proxyRealm) {
        this.mdrBaseUrl = mdrBaseUrl;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.proxyRealm = proxyRealm;
    }

    public MdrClient(String mdrBaseUrl, Client client) {
        this.mdrBaseUrl = mdrBaseUrl;
        this.jerseyClient = client;
    }

    protected final String getJsonLabel(String memberId, String languageCode, EnumElementType enumElementType, String accessToken, String userAuthId) throws MdrConnectionException, ExecutionException {
        String path = "";
        if (enumElementType.equals((Object)EnumElementType.RECORD)) {
            path = "records/" + memberId + PATH_SEPARATOR + LABELS;
        } else if (enumElementType.equals((Object)EnumElementType.DATAELEMENTGROUP)) {
            path = "dataelementgroups/" + memberId + PATH_SEPARATOR + LABELS;
        } else if (enumElementType.equals((Object)EnumElementType.DATAELEMENT)) {
            path = "dataelements/" + memberId + PATH_SEPARATOR + LABELS;
        }
        String json = accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
        return json;
    }

    public final List<Label> getRecordLabel(String recordId, String languageCode) throws MdrConnectionException, ExecutionException {
        return this.getRecordLabel(recordId, languageCode, null, null);
    }

    public final List<Label> getRecordLabel(String recordId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, ExecutionException {
        String response = this.getJsonLabel(recordId, languageCode, EnumElementType.RECORD, accessToken, userAuthId);
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<Label>>(){}.getType();
        List labels = (List)gson.fromJson(response, listType);
        return labels;
    }

    public final List<Label> getDataElementGroupLabel(String recordId, String languageCode) throws MdrConnectionException, ExecutionException {
        return this.getDataElementGroupLabel(recordId, languageCode, null, null);
    }

    public final List<Label> getDataElementGroupLabel(String groupId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, ExecutionException {
        String response = this.getJsonLabel(groupId, languageCode, EnumElementType.DATAELEMENTGROUP, accessToken, userAuthId);
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<Label>>(){}.getType();
        List labels = (List)gson.fromJson(response, listType);
        return labels;
    }

    public final ArrayList<Slot> getRecordSlots(String mdrRecordId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getRecordSlots(mdrRecordId, null, null);
    }

    public final ArrayList<Slot> getRecordSlots(String mdrRecordId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonRecordSlots(mdrRecordId, accessToken, userAuthId);
        Gson gson = new Gson();
        ArrayList recordSlots = (ArrayList)gson.fromJson(response, new TypeToken<ArrayList<Slot>>(){}.getType());
        return recordSlots;
    }

    protected final String getJsonRecordMembers(String mdrGroupId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, ExecutionException {
        String path = "records/" + mdrGroupId + PATH_SEPARATOR + MEMBERS;
        return accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
    }

    public final List<Result> getRecordMembers(String recordId, String languageCode) throws MdrConnectionException, ExecutionException {
        return this.getRecordMembers(recordId, languageCode, null, null);
    }

    public final List<Result> getRecordMembers(String recordId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, ExecutionException {
        String response = this.getJsonRecordMembers(recordId, languageCode, accessToken, userAuthId);
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<Result>>(){}.getType();
        ArrayList members = (ArrayList)gson.fromJson(response, listType);
        return members;
    }

    protected final String getJsonMembers(String mdrGroupId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, ExecutionException {
        String path = "dataelementgroups/" + mdrGroupId + PATH_SEPARATOR + MEMBERS;
        return accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
    }

    public final List<Result> getMembers(String mdrGroupId, String languageCode) throws MdrConnectionException, ExecutionException {
        return this.getMembers(mdrGroupId, languageCode, null, null);
    }

    public final List<Result> getMembers(String mdrGroupId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, ExecutionException {
        String response = this.getJsonMembers(mdrGroupId, languageCode, accessToken, userAuthId);
        Gson gson = new Gson();
        ResultList members = (ResultList)gson.fromJson(response, ResultList.class);
        return members.getResults();
    }

    protected final String getJson(String path, String languageCode) throws ExecutionException {
        CacheKey key = new CacheKey(path, languageCode);
        return (String)CacheManager.getCache(this).get((Object)key);
    }

    protected final String getJson(String path, String languageCode, String accessToken, String userAuthId) throws ExecutionException {
        CacheKey key = new CacheKey(path, languageCode, accessToken, userAuthId);
        return (String)CacheManager.getCache(this).get((Object)key);
    }

    final String getJsonFromMdr(String path, String languageCode) throws MdrConnectionException {
        String string = null;
        try {
            string = (String)this.getService().path(path).request(new String[]{"application/json"}).header("Accept-Language", (Object)languageCode).get(String.class);
        }
        catch (Exception e) {
            throw new MdrConnectionException(e.getMessage());
        }
        return string;
    }

    final String getJsonFromMdr(String path, String languageCode, String accessToken) throws MdrConnectionException {
        String string = null;
        try {
            string = (String)this.getService().path(path).request(new String[]{"application/json"}).header("Accept-Language", (Object)languageCode).header("Authorization", (Object)("Bearer " + accessToken)).get(String.class);
        }
        catch (Exception e) {
            throw new MdrConnectionException(e.getMessage());
        }
        return string;
    }

    @Deprecated
    public final List<Result> getDataElementsFromGroup(String mdrGroupId, String languageCode) throws MdrConnectionException, ExecutionException {
        return this.getDataElementsFromGroup(mdrGroupId, languageCode, null, null);
    }

    @Deprecated
    public final List<Result> getDataElementsFromGroup(String mdrGroupId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, ExecutionException {
        String response = this.getJsonMembers(mdrGroupId, languageCode, accessToken, userAuthId);
        Gson gson = new Gson();
        ResultList dataElements = (ResultList)gson.fromJson(response, ResultList.class);
        return this.filterMembers(dataElements.getResults(), EnumElementType.DATAELEMENT);
    }

    protected final String getJsonDataElementValidations(String mdrDataElementId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "dataelements/" + mdrDataElementId + PATH_SEPARATOR + VALIDATIONS_PATH;
        String string = json = accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrDataElementId + ". Is the MDR ID valid?");
    }

    protected final String getJsonDataElementCatalogue(String mdrDataElementId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "dataelements/" + mdrDataElementId + PATH_SEPARATOR + CATALOGUE_PATH;
        String string = json = accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrDataElementId + ". Is the MDR ID valid and is it a catalogue?");
    }

    protected final String getJsonCatalogue(String catalogueId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "catalogs/" + catalogueId + PATH_SEPARATOR + CODES_PATH;
        String string = json = accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + catalogueId + ". Is the MDR ID valid and is it a catalogue?");
    }

    protected final String getJsonDataElementSlots(String mdrDataElementId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "dataelements/" + mdrDataElementId + PATH_SEPARATOR + SLOTS;
        String string = json = accessToken == null ? this.getJson(path, "en") : this.getJson(path, "en", accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrDataElementId + ". Is the MDR ID valid?");
    }

    protected final String getJsonDataElementGroupSlots(String mdrDataElementGroupId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "dataelementgroups/" + mdrDataElementGroupId + PATH_SEPARATOR + SLOTS;
        String string = json = accessToken == null ? this.getJson(path, "en") : this.getJson(path, "en", accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrDataElementGroupId + ". Is the MDR ID valid?");
    }

    protected final String getJsonRecordSlots(String mdrRecordId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "records/" + mdrRecordId + PATH_SEPARATOR + SLOTS;
        String string = json = accessToken == null ? this.getJson(path, "en") : this.getJson(path, "en", accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrRecordId + ". Is the MDR ID valid?");
    }

    protected final String getJsonCodeSlots(String mdrCatalogueId, String mdrCodeId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "catalogs/" + mdrCatalogueId + PATH_SEPARATOR + CODES_PATH + PATH_SEPARATOR + mdrCodeId + PATH_SEPARATOR + SLOTS;
        String string = json = accessToken == null ? this.getJson(path, "en") : this.getJson(path, "en", accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrCodeId + ". Is the MDR ID valid?");
    }

    public final ArrayList<Slot> getDataElementSlots(String mdrDataElementId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getDataElementSlots(mdrDataElementId, null, null);
    }

    public final ArrayList<Slot> getDataElementSlots(String mdrDataElementId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonDataElementSlots(mdrDataElementId, accessToken, userAuthId);
        Gson gson = new Gson();
        ArrayList dataElementSlots = (ArrayList)gson.fromJson(response, new TypeToken<ArrayList<Slot>>(){}.getType());
        return dataElementSlots;
    }

    public final ArrayList<Slot> getDataElementGroupSlots(String mdrDataElementGroupId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getDataElementGroupSlots(mdrDataElementGroupId, null, null);
    }

    public final ArrayList<Slot> getDataElementGroupSlots(String mdrDataElementGroupId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonDataElementGroupSlots(mdrDataElementGroupId, accessToken, userAuthId);
        Gson gson = new Gson();
        ArrayList dataGroupSlots = (ArrayList)gson.fromJson(response, new TypeToken<ArrayList<Slot>>(){}.getType());
        return dataGroupSlots;
    }

    public final Code getCode(String mdrCatalogueId, String mdrCodeId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getCode(mdrCatalogueId, mdrCodeId, null, null);
    }

    public final Code getCode(String mdrCatalogueId, String mdrCodeId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonCode(mdrCatalogueId, mdrCodeId, accessToken, userAuthId);
        Gson gson = new Gson();
        Code code = (Code)gson.fromJson(response, Code.class);
        return code;
    }

    protected final String getJsonCode(String mdrCatalogueId, String mdrCodeId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "catalogs/" + mdrCatalogueId + PATH_SEPARATOR + CODES_PATH + PATH_SEPARATOR + mdrCodeId;
        String string = json = accessToken == null ? this.getJson(path, "en") : this.getJson(path, "en", accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrCodeId + ". Is the MDR ID valid?");
    }

    public final ArrayList<Slot> getCodeSlots(String mdrCatalogueId, String mdrCodeId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getCodeSlots(mdrCatalogueId, mdrCodeId, null, null);
    }

    public final ArrayList<Slot> getCodeSlots(String mdrCatalogueId, String mdrCodeId, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonCodeSlots(mdrCatalogueId, mdrCodeId, accessToken, userAuthId);
        Gson gson = new Gson();
        ArrayList codeSlots = (ArrayList)gson.fromJson(response, new TypeToken<ArrayList<Slot>>(){}.getType());
        return codeSlots;
    }

    protected final String getJsonSearch(String searchText, String languageCode, String accessToken, String namespace) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json = null;
        String path = "";
        if (namespace != null && namespace.length() > 0) {
            path = "namespaces/" + namespace + PATH_SEPARATOR;
        }
        path = path + SEARCH;
        json = (String)this.getService().path(path.toString()).queryParam("query", new Object[]{searchText}).request(new String[]{"application/json"}).header("Accept-Language", (Object)languageCode).header("Authorization", (Object)("Bearer " + accessToken)).get(String.class);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for the search query: " + searchText);
    }

    protected final String getJsonSearchLocal(String searchText, String languageCode, String accessToken) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(TYPE_DATAELEMENT);
        typeList.add(TYPE_DATAELEMENTGROUP);
        String json = null;
        String path = "search/local";
        json = (String)this.getService().path(path.toString()).queryParam("query", new Object[]{searchText}).queryParam("status", new Object[]{STATUS_RELEASED}).queryParam("type", new Object[]{typeList}).request(new String[]{"application/json"}).header("Accept-Language", (Object)languageCode).header("Authorization", (Object)("Bearer " + accessToken)).get(String.class);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for the search query: " + searchText);
    }

    public final Validations getDataElementValidations(String mdrDataElementId, String languageCode) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getDataElementValidations(mdrDataElementId, languageCode, null, null);
    }

    public final Validations getDataElementValidations(String mdrDataElementId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonDataElementValidations(mdrDataElementId, languageCode, accessToken, userAuthId);
        Gson gson = new Gson();
        Validations dataElementValidations = (Validations)gson.fromJson(response, Validations.class);
        return dataElementValidations;
    }

    public final Catalogue getDataElementCatalogue(String mdrDataElementId, String languageCode) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getDataElementCatalogue(mdrDataElementId, languageCode, null, null);
    }

    public final Catalogue getDataElementCatalogue(String mdrDataElementId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonDataElementCatalogue(mdrDataElementId, languageCode, accessToken, userAuthId);
        Gson gson = new Gson();
        Catalogue catalogue = (Catalogue)gson.fromJson(response, Catalogue.class);
        return catalogue;
    }

    public final Catalogue getCatalogue(String catalogueId, String languageCode) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getCatalogue(catalogueId, languageCode, null, null);
    }

    public final Catalogue getCatalogue(String catalogueId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonCatalogue(catalogueId, languageCode, accessToken, userAuthId);
        Gson gson = new Gson();
        Catalogue catalogue = (Catalogue)gson.fromJson(response, Catalogue.class);
        return catalogue;
    }

    public final List<Result> search(String searchText, String languageCode, String accessToken) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        logger.debug("lang " + languageCode);
        String response = this.getJsonSearch(searchText, languageCode, accessToken, null);
        Gson gson = new Gson();
        ResultList results = (ResultList)gson.fromJson(response, ResultList.class);
        return results.getResults();
    }

    public final List<Result> searchInNamespace(String searchText, String languageCode, String accessToken, String namespace) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonSearch(searchText, languageCode, accessToken, namespace);
        Gson gson = new Gson();
        ResultList results = (ResultList)gson.fromJson(response, ResultList.class);
        return results.getResults();
    }

    public final List<Result> searchLocal(String searchText, String languageCode, String accessToken) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String response = this.getJsonSearchLocal(searchText, languageCode, accessToken);
        Gson gson = new Gson();
        ResultList results = (ResultList)gson.fromJson(response, ResultList.class);
        return results.getResults();
    }

    protected final String getJsonDataElementDefinition(String mdrDataElementId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "dataelements/" + mdrDataElementId + PATH_SEPARATOR + DESIGNATION_PATH;
        String string = json = accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrDataElementId + ". Is the MDR ID valid?");
    }

    protected final String getJsonDataElement(String mdrDataElementId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "dataelements/" + mdrDataElementId;
        String string = json = accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrDataElementId + ". Is the MDR ID valid?");
    }

    protected final String getJsonRecordDefinition(String mdrRecordId, String languageCode, String accessToken, String userAuthId) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        String json;
        String path = "records/" + mdrRecordId + PATH_SEPARATOR + LABELS;
        String string = json = accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
        if (json != null && !json.isEmpty()) {
            return json;
        }
        throw new MdrInvalidResponseException("Unexpected response for " + mdrRecordId + ". Is the MDR ID valid?");
    }

    public final Definition getDataElementDefinition(String mdrDataElementId, String languageCode) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getDataElementDefinition(mdrDataElementId, languageCode, null, null);
    }

    public final Definition getDataElementDefinition(String mdrDataElementId, String languageCode, String accessToken, String userAccessToken) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        logger.debug("Getting data element definition for " + mdrDataElementId + " | " + languageCode + " | " + accessToken);
        String response = this.getJsonDataElementDefinition(mdrDataElementId, languageCode, accessToken, userAccessToken);
        Gson gson = new Gson();
        Definition dataElementDefinition = (Definition)gson.fromJson(response, Definition.class);
        return dataElementDefinition;
    }

    public final RecordDefinition getRecordDefinition(String mdrRecordId, String languageCode) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getRecordDefinition(mdrRecordId, languageCode, null, null);
    }

    public final RecordDefinition getRecordDefinition(String mdrRecordId, String languageCode, String accessToken, String userAccessToken) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        logger.debug("Getting record  definition for " + mdrRecordId + " | " + languageCode + " | " + accessToken);
        String response = this.getJsonRecordDefinition(mdrRecordId, languageCode, accessToken, userAccessToken);
        Gson gson = new Gson();
        RecordDefinition recordDefinition = (RecordDefinition)gson.fromJson(response, RecordDefinition.class);
        return recordDefinition;
    }

    public final List<Result> filterMembers(List<Result> members, EnumElementType enumElementType) {
        Iterator<Result> iterator = members.iterator();
        while (iterator.hasNext()) {
            Result result = iterator.next();
            if (result.getType().compareTo(enumElementType.name()) == 0) continue;
            iterator.remove();
        }
        return members;
    }

    protected final String getJsonNamespaces(String languageCode, String accessToken, String userAuthId) throws ExecutionException {
        String path = NAMESPACES_PATH;
        return accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
    }

    protected final String getJsonNamespaceMembers(String languageCode, String accessToken, String userAuthId, String namespace) throws ExecutionException {
        String path = "namespaces/" + namespace + PATH_SEPARATOR + MEMBERS;
        return accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
    }

    protected final String getUserJsonRootElements(String languageCode, String accessToken, String userAuthId) throws ExecutionException {
        String path = MEMBERS;
        return accessToken == null ? this.getJson(path, languageCode) : this.getJson(path, languageCode, accessToken, userAuthId);
    }

    public final List<Namespace> getNamespaces(String languageCode) throws ExecutionException {
        return this.getNamespaces(languageCode, null, null);
    }

    public final List<Namespace> getNamespaces(String languageCode, String accessToken, String userAuthId) throws ExecutionException {
        String response = this.getJsonNamespaces(languageCode, accessToken, userAuthId);
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<Namespace>>(){}.getType();
        List namespaces = (List)gson.fromJson(response, listType);
        return namespaces;
    }

    public final List<Result> getNamespaceMembers(String languageCode, String namespace) throws ExecutionException {
        return this.getNamespaceMembers(languageCode, null, null, namespace);
    }

    public final List<Result> getNamespaceMembers(String languageCode, String accessToken, String userAuthId, String namespace) throws ExecutionException {
        String response = this.getJsonNamespaceMembers(languageCode, accessToken, userAuthId, namespace);
        Gson gson = new Gson();
        ResultList resultList = (ResultList)gson.fromJson(response, ResultList.class);
        return resultList.getResults();
    }

    public final ResultList getUserRootElements(String languageCode, String accessToken, String userAuthId) throws ExecutionException {
        String response = this.getUserJsonRootElements(languageCode, accessToken, userAuthId);
        Gson gson = new Gson();
        ResultList members = (ResultList)gson.fromJson(response, ResultList.class);
        return members;
    }

    public final ResultList getUserNamespaceRepresentations(String mdrDataElementId, String accessToken, String userAuthId) throws ExecutionException {
        String json = null;
        String path = REPRESENTATIONS;
        json = (String)this.getService().path(path.toString()).queryParam("urn", new Object[]{mdrDataElementId}).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get(String.class);
        Gson gson = new Gson();
        ResultList resultList = (ResultList)gson.fromJson(json, ResultList.class);
        return resultList;
    }

    public final DataElement getDataElement(String mdrDataElementId, String languageCode) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        return this.getDataElement(mdrDataElementId, languageCode, null, null);
    }

    public final DataElement getDataElement(String mdrDataElementId, String languageCode, String accessToken, String userAccessToken) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        logger.trace("Getting data element " + mdrDataElementId + " | " + languageCode + " | " + accessToken);
        String response = this.getJsonDataElement(mdrDataElementId, languageCode, accessToken, userAccessToken);
        Gson gson = new Gson();
        return (DataElement)gson.fromJson(response, DataElement.class);
    }

    public final void cleanCache() {
        logger.debug("Cleaning the cache...");
        CacheManager.cleanCache(this);
    }

    public final URI getBaseUri() {
        return UriBuilder.fromUri((String)this.mdrBaseUrl).build(new Object[0]);
    }

    private void setProxy(String proxyHost, String proxyPort) {
        System.setProperty(HTTP_PROXY_HOST_PROPERTY, proxyHost);
        System.setProperty(HTTP_PROXY_PORT_PROPERTY, proxyPort);
    }

    private WebTarget getService() {
        if (this.jerseyClient != null) {
            return this.jerseyClient.target(this.getBaseUri());
        }
        ClientConfig config = new ClientConfig();
        Client client = ClientBuilder.newClient((Configuration)config);
        WebTarget service = client.target(this.getBaseUri());
        return service;
    }

    private ConnectionFactory getConnectionFactory() {
        ConnectionFactory cf = new ConnectionFactory();
        if (this.proxyPort != null && this.proxyPort.length() > 0) {
            cf.setProxyHost(this.proxyHost);
            cf.setProxyPort(this.proxyPort);
            if (this.proxyUsername != null && this.proxyUsername.length() > 0) {
                cf.setUsername(this.proxyUsername);
                cf.setPassword(this.proxyPassword);
            }
        }
        if (this.proxyRealm != null && this.proxyRealm.length() > 0) {
            cf.setProxyRealm(this.proxyRealm);
        }
        return cf;
    }
}

