/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.mdrclient.lastresort;

import de.samply.common.mdrclient.MdrClient;
import de.samply.common.mdrclient.MdrConnectionException;
import de.samply.common.mdrclient.MdrInvalidResponseException;
import de.samply.common.mdrclient.domain.DataElement;
import de.samply.common.mdrclient.lastresort.MdrAlternativeDesignation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;

public class MdrLastResort {
    private static final String MDR_ID_URL_SEPARATOR = ":";
    private Map<MdrIdAndLanguage, String> mdrIdAlternativeDesignationMap = new HashMap<MdrIdAndLanguage, String>();
    private MdrClient mdrClient;

    public MdrLastResort(MdrClient mdrClient) {
        this.mdrClient = mdrClient;
    }

    public void addAlterntiveDesignations(Collection<MdrAlternativeDesignation> alternativeDesignations) {
        for (MdrAlternativeDesignation mdrAlternativeDesignation : alternativeDesignations) {
            MdrIdAndLanguage mdrIdAndLanguage = this.createMdrIdAndLanguage(mdrAlternativeDesignation.getMdrId(), mdrAlternativeDesignation.getLanguageCode());
            this.mdrIdAlternativeDesignationMap.put(mdrIdAndLanguage, mdrAlternativeDesignation.getDesignation());
        }
    }

    private MdrIdAndLanguage createMdrIdAndLanguage(String mdrId, String languageCode) {
        mdrId = this.getMdrIdCore(mdrId);
        return new MdrIdAndLanguage(mdrId, languageCode);
    }

    public String getDesignation(String mdrId, String languageCode) {
        String currentDesignation = this.getCurrentDesignation(mdrId, languageCode);
        String alternativeDesignation = this.getAlternativeDesignation(mdrId, languageCode);
        return alternativeDesignation == null ? currentDesignation : alternativeDesignation;
    }

    private String getMdrIdCore(String mdrId) {
        int matches = StringUtils.countMatches((CharSequence)mdrId, (CharSequence)MDR_ID_URL_SEPARATOR);
        if (matches == 4) {
            int index = mdrId.lastIndexOf(MDR_ID_URL_SEPARATOR);
            mdrId = mdrId.substring(0, index);
        }
        return mdrId;
    }

    private String getAlternativeDesignation(String mdrId, String languageCode) {
        mdrId = this.getMdrIdCore(mdrId);
        MdrIdAndLanguage mdrIdAndLanguage = new MdrIdAndLanguage(mdrId, languageCode);
        return this.mdrIdAlternativeDesignationMap.get(mdrIdAndLanguage);
    }

    private String getCurrentDesignation(String mdrId, String languageCode) {
        try {
            return this.getCurrentDesignation_WithoutManagementException(mdrId, languageCode);
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (MdrConnectionException e) {
            return null;
        }
        catch (MdrInvalidResponseException e) {
            return null;
        }
    }

    private String getCurrentDesignation_WithoutManagementException(String mdrId, String languageCode) throws ExecutionException, MdrConnectionException, MdrInvalidResponseException {
        DataElement dataElement = this.mdrClient.getDataElement(mdrId, languageCode);
        return dataElement.getDesignations().get(0).getDesignation();
    }

    private class MdrIdAndLanguage {
        private String mdrId;
        private String languageCode;

        public MdrIdAndLanguage(String mdrId, String languageCode) {
            this.mdrId = mdrId;
            this.languageCode = languageCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MdrIdAndLanguage that = (MdrIdAndLanguage)o;
            return this.mdrId.equals(that.mdrId) && this.languageCode.equals(that.languageCode);
        }

        public int hashCode() {
            return Objects.hash(this.mdrId, this.languageCode);
        }
    }
}

