/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.gem.GemArtifact;
import de.saumya.mojo.gem.GemspecWriter;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Relocation;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemifyMojo
extends AbstractGemMojo {
    String artifactId;
    String groupId;
    String version;
    File gemify;
    File buildDirectory;
    public boolean skipGemInstall = false;
    private Object repositorySession;
    protected ProjectBuilder builder;
    private final Map<String, String> relocationMap = new HashMap<String, String>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeJRuby() throws MojoExecutionException, IOException, ScriptException {
        if (this.project.getBasedir() == null || !this.project.getBasedir().exists()) {
            if (!this.buildDirectory.exists()) {
                this.buildDirectory = new File("target");
            }
            if (!this.gemify.exists()) {
                this.gemify = new File(this.buildDirectory, "gemify");
            }
        }
        if (this.artifactId != null || this.groupId != null || this.version != null) {
            if (this.artifactId == null || this.groupId == null || this.version == null) throw new MojoExecutionException("not all three artifactId, groupId and version are given");
            Artifact artifact = this.repositorySystem.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, "jar", null);
            ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setLocalRepository(this.localRepository).setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            this.repositorySystem.resolve(request);
            try {
                MavenProject project = this.projectFromArtifact(artifact);
                project.setArtifact(artifact);
                LinkedHashSet artifacts = new LinkedHashSet();
                this.getLog().info((CharSequence)("artifacts=" + artifacts));
                request = new ArtifactResolutionRequest().setArtifact(artifact).setLocalRepository(this.localRepository).setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setManagedVersionMap(project.getManagedVersionMap());
                ArtifactResolutionResult arr = this.repositorySystem.resolve(request);
                this.gemify(project, arr.getArtifacts());
                return;
            }
            catch (InvalidDependencyVersionException e) {
                throw new MojoExecutionException("can not resolve " + artifact.toString(), (Exception)((Object)e));
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("error building project object model", (Exception)((Object)e));
            }
            catch (GemException e) {
                throw new MojoExecutionException("error building project object model", (Exception)((Object)e));
            }
        } else {
            this.gemify(this.project, this.project.getArtifacts());
        }
    }

    private void gemify(MavenProject project, Set<Artifact> artifacts) throws MojoExecutionException, IOException, ScriptException {
        this.getLog().info((CharSequence)("gemify( " + project + ", " + artifacts + " )"));
        HashMap<String, MavenProject> gems = new HashMap<String, MavenProject>();
        try {
            if (project.getArtifact().getFile() == null) {
                throw new MojoExecutionException("no artifact file found: " + project.getArtifact() + "\n\trun 'package' goal first");
            }
            String gem = this.build(project, project.getArtifact().getFile());
            gems.put(gem, project);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error gemifing pom", (Exception)e);
        }
        for (Artifact artifact : artifacts) {
            if (!"jar".equals(artifact.getType()) || artifact.hasClassifier()) continue;
            try {
                project = this.projectFromArtifact(artifact);
                String gem = this.build(project, artifact.getFile());
                gems.put(gem, project);
            }
            catch (ProjectBuildingException e) {
                this.getLog().error((CharSequence)("skipping: " + artifact.getFile().getName()), (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("skipping: " + artifact.getFile().getName()), (Throwable)e);
            }
            catch (GemException e) {
                this.getLog().error((CharSequence)("skipping: " + artifact.getFile().getName()), (Throwable)e);
            }
        }
        if (this.skipGemInstall) {
            this.getLog().info((CharSequence)"skip installing gems");
        } else {
            Script script = this.factory.newScriptFromJRubyJar("gem").addArg("install").addArg((this.installRDoc ? "--" : "--no-") + "rdoc").addArg((this.installRI ? "--" : "--no-") + "ri").addArg("--ignore-dependencies").addArg("-l");
            for (String gem : gems.keySet()) {
                script.addArg(gem);
            }
            script.executeIn(this.launchDirectory());
        }
    }

    private MavenProject projectFromArtifact(Artifact artifact) throws ProjectBuildingException, GemException {
        ProjectBuildingRequest request = new DefaultProjectBuildingRequest().setLocalRepository(this.localRepository).setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        this.manager.setRepositorySession(request, this.repositorySession);
        MavenProject project = this.builder.build(artifact, request).getProject();
        if (project.getDistributionManagement() != null && project.getDistributionManagement().getRelocation() != null) {
            Relocation reloc = project.getDistributionManagement().getRelocation();
            String key = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getVersion();
            artifact.setArtifactId(reloc.getArtifactId());
            artifact.setGroupId(reloc.getGroupId());
            if (reloc.getVersion() != null) {
                artifact.setVersion(reloc.getVersion());
            }
            this.relocationMap.put(key, artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getVersion());
            return this.projectFromArtifact(artifact);
        }
        return project;
    }

    private String build(MavenProject project, File jarfile) throws MojoExecutionException, IOException, ScriptException {
        this.getLog().info((CharSequence)("building gem for " + jarfile + " . . ."));
        String gemName = project.getGroupId() + "." + project.getArtifactId();
        File gemDir = new File(this.gemify, gemName);
        File gemSpec = new File(gemDir, gemName + ".gemspec");
        GemspecWriter gemSpecWriter = new GemspecWriter(gemSpec, project, new GemArtifact(project));
        gemSpecWriter.appendJarfile(jarfile, jarfile.getName());
        File lib = new File(gemDir, "lib");
        lib.mkdirs();
        File rubyFile = new File(lib.getName(), project.getGroupId() + "." + project.getArtifactId() + ".rb");
        gemSpecWriter.appendFile(rubyFile);
        for (Dependency dependency : project.getDependencies()) {
            if (dependency.isOptional() || !"jar".equals(dependency.getType()) || dependency.getClassifier() != null) continue;
            this.getLog().info((CharSequence)"--");
            this.getLog().info((CharSequence)("dependency=" + dependency));
            Artifact arti = null;
            try {
                arti = this.repositorySystem.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getClassifier());
                this.getLog().info((CharSequence)("arti=" + arti));
                this.projectFromArtifact(arti);
                dependency.setGroupId(arti.getGroupId());
                dependency.setArtifactId(arti.getArtifactId());
                dependency.setVersion(arti.getVersion());
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("error building project for " + arti, (Exception)((Object)e));
            }
            catch (GemException e) {
                throw new MojoExecutionException("error building project for " + arti, (Exception)((Object)e));
            }
            if ("compileruntime".contains(dependency.getScope())) {
                gemSpecWriter.appendDependency(dependency.getGroupId() + "." + dependency.getArtifactId(), dependency.getVersion());
                continue;
            }
            if (!"providedtest".contains(dependency.getScope())) continue;
            gemSpecWriter.appendDevelopmentDependency(dependency.getGroupId() + "." + dependency.getArtifactId(), dependency.getVersion());
        }
        this.getLog().debug((CharSequence)"<gemify> A");
        gemSpecWriter.close();
        gemSpecWriter.copy(gemDir);
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(new File(lib, rubyFile.getName()));
            writer.append("module ").append(this.titleizedClassname(project.getArtifactId())).append("\n");
            writer.append("  VERSION = '").append(this.gemVersion(project.getVersion())).append("'\n");
            writer.append("  MAVEN_VERSION = '").append(project.getVersion()).append("'\n");
            writer.append("end\n");
            writer.append("begin\n");
            writer.append("  require 'java'\n");
            writer.append("  require File.dirname(__FILE__) + '/").append(jarfile.getName()).append("'\n");
            writer.append("rescue LoadError\n");
            writer.append("  puts 'JAR-based gems require JRuby to load. Please visit www.jruby.org.'\n");
            writer.append("  raise\n");
            writer.append("end\n");
        }
        catch (IOException e) {
            throw new MojoExecutionException("error writing ruby file", (Exception)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
        this.getLog().debug((CharSequence)"<gemify> B");
        this.factory.newScriptFromJRubyJar("gem").addArg("build").addArg(gemSpec).executeIn(gemDir);
        this.getLog().debug((CharSequence)"<gemify> C");
        return gemSpec.getAbsolutePath().replaceFirst(".gemspec$", "") + "-" + this.gemVersion(project.getVersion()) + ".gem";
    }

    private String titleizedClassname(String artifactId) {
        StringBuilder name = new StringBuilder();
        for (String part : artifactId.split("-")) {
            name.append(StringUtils.capitalise((String)part));
        }
        return name.toString();
    }

    private String gemVersion(String versionString) {
        return versionString.replaceAll("-SNAPSHOT", "").replace("-", ".").toLowerCase();
    }

    @Override
    protected void executeWithGems() throws MojoExecutionException, ScriptException, IOException {
    }
}

