/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gem.GemArtifact;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

class GemspecWriter {
    final MavenProject project;
    final Writer writer;
    final String excludes = ".*~$|^[.][a-zA-Z].*";
    final List<File> dirs = new ArrayList<File>();
    final List<File> files = new ArrayList<File>();
    final List<URL> licenses = new ArrayList<URL>();
    final Map<String, File> jarFiles = new HashMap<String, File>();
    long latestModified = 0L;
    final File gemspec;
    private boolean firstAuthor = true;
    private boolean firstFile = true;
    private boolean platformAppended = false;
    private boolean firstTestFile;

    GemspecWriter(File gemspec, MavenProject project, GemArtifact artifact) throws IOException {
        this.latestModified = project.getFile() == null ? 0L : project.getFile().lastModified();
        this.gemspec = gemspec;
        this.gemspec.getParentFile().mkdirs();
        this.writer = new FileWriter(gemspec);
        this.project = project;
        this.append("# create by maven - leave it as is");
        this.append("Gem::Specification.new do |s|");
        this.append("name", artifact.getGemName());
        this.appendRaw("version", "'" + GemArtifact.getGemVersion(project.getVersion()) + "'");
        this.append();
        this.append("summary", project.getName());
        this.append("description", project.getDescription());
        this.append("homepage", project.getUrl());
        this.append();
        for (Developer developer : project.getDevelopers()) {
            this.appendAuthor(developer.getName(), developer.getEmail());
        }
        for (Contributor contributor : project.getContributors()) {
            this.appendAuthor(contributor.getName(), contributor.getEmail());
        }
        if (project.getDevelopers().isEmpty() && project.getContributors().isEmpty()) {
            this.appendList("authors", "dummy");
        }
        this.append();
        for (License license : project.getLicenses()) {
            this.appendLicense(license.getUrl(), license.getName());
        }
    }

    boolean isUptodate() {
        return this.gemspec.lastModified() > this.latestModified;
    }

    private String gemVersion(String version) {
        if ((version = version.replaceAll("-SNAPSHOT", "").replace("-", ".")).matches("^[\\[\\(].*[\\]\\)]$")) {
            int comma = version.indexOf(",");
            String first = version.substring(1, comma);
            String second = version.substring(comma + 1, version.length() - 1);
            if (version.matches("\\[.*99999.99999\\)$")) {
                String prefix = second.replaceFirst("99999.99999$", "");
                return "'~> " + prefix + first.substring(prefix.length()).replaceFirst("[.].*", "") + "'";
            }
            if (version.matches("\\[.*,\\)$")) {
                StringBuilder buf = new StringBuilder("'>");
                buf.append(version.charAt(0) == '[' ? "=" : "");
                buf.append(first).append("'");
                return buf.toString();
            }
            StringBuilder buf = new StringBuilder("['>");
            buf.append(version.charAt(0) == '[' ? "=" : "");
            buf.append(first).append("','<");
            buf.append(version.charAt(version.length() - 1) == '[' ? "=" : "");
            buf.append(second);
            buf.append("']");
            return buf.toString();
        }
        return "'" + version + "'";
    }

    private void append() throws IOException {
        this.writer.append("\n");
    }

    private void append(String line) throws IOException {
        this.writer.append(line).append("\n");
    }

    private void appendAuthor(String name, String email) throws IOException {
        if (name != null && email != null) {
            if (this.firstAuthor) {
                this.writer.append("  s.authors = ['").append(name).append("']\n");
                this.writer.append("  s.email = ['").append(email).append("']\n");
                this.firstAuthor = false;
            } else {
                this.writer.append("  s.authors << '").append(name).append("'\n");
                this.writer.append("  s.email << '").append(email).append("'\n");
            }
        }
    }

    void append(String key, String value) throws IOException {
        if (value != null) {
            this.writer.append("  s.").append(key).append(" = '").append(value.replaceAll("'", "\"")).append("'\n");
        }
    }

    private void appendRaw(String key, String value) throws IOException {
        if (value != null) {
            this.writer.append("  s.").append(key).append(" = ").append(value).append("\n");
        }
    }

    void appendDependency(String name, String version) throws IOException {
        this.writer.append("  s.add_dependency '").append(name).append("', ").append(this.gemVersion(version)).append("\n");
    }

    void appendDevelopmentDependency(String name, String version) throws IOException {
        this.writer.append("  s.add_development_dependency '").append(name).append("', ").append(this.gemVersion(version)).append("\n");
    }

    void appendPath(String path) throws IOException {
        if (this.firstFile) {
            this.writer.append("  s.files = Dir['").append(path).append("/**/*']\n");
            this.firstFile = false;
        } else {
            this.writer.append("  s.files += Dir['").append(path).append("/**/*']\n");
        }
        File file = new File(this.project.getBasedir(), path);
        if (file.lastModified() > this.latestModified) {
            this.latestModified = file.lastModified();
        }
        this.dirs.add(new File(path));
    }

    void appendTestPath(String path) throws IOException {
        if (this.firstTestFile) {
            this.writer.append("  s.test_files = Dir['").append(path).append("/**/*_" + path + ".rb']\n");
            this.firstTestFile = false;
        } else {
            this.writer.append("  s.test_files += Dir['").append(path).append("/**/*_" + path + ".rb']\n");
        }
        File file = new File(this.project.getBasedir(), path);
        if (file.lastModified() > this.latestModified) {
            this.latestModified = file.lastModified();
        }
        this.dirs.add(new File(path));
    }

    void appendPlatform(String platform) throws IOException {
        if (!this.platformAppended && platform != null) {
            this.append("platform", platform);
            this.platformAppended = true;
        }
    }

    void appendJarfile(File jar, String jarfileName) throws IOException {
        File f = new File("lib", jarfileName);
        this.jarFiles.put(f.toString(), jar);
        this.appendFile(f);
    }

    void appendFile(File file) throws IOException {
        if (this.firstFile) {
            this.writer.append("  s.files = Dir['").append(file.toString()).append("']\n");
            this.firstFile = false;
        } else {
            this.writer.append("  s.files += Dir['").append(file.toString()).append("']\n");
        }
        if (file.lastModified() > this.latestModified) {
            this.latestModified = file.lastModified();
        }
    }

    void appendFile(String file) throws IOException {
        File f = new File(file);
        this.appendFile(f);
        this.files.add(f);
    }

    void appendExecutable(String executable) throws IOException {
        this.writer.append("  s.executables << '" + executable + "'\n");
    }

    private void appendLicense(String url, String name) throws IOException {
        URL u;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            u = new URL("file:." + url);
        }
        this.licenses.add(u);
        URLConnection con = u.openConnection();
        if (this.latestModified < con.getLastModified()) {
            this.latestModified = con.getLastModified();
        }
        File license = new File(u.getFile().substring(1).replaceFirst("^./", ""));
        this.appendFile(license);
        if ("file".equals(u.getProtocol())) {
            this.files.add(new File(license.getPath().replaceFirst("^./", "")));
        }
        if (name != null) {
            this.append("  s.licenses << '" + name.replaceFirst("^./", "") + "'");
        }
    }

    void copy(File target) throws IOException {
        target.mkdirs();
        this.copyJarFiles(target);
        this.copyFiles(target);
        this.copyLicenses(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLicenses(File target) throws IOException {
        OutputStream writer = null;
        BufferedInputStream reader = null;
        for (URL url : this.licenses) {
            try {
                try {
                    reader = new BufferedInputStream(url.openStream());
                }
                catch (IOException e) {
                    if (reader != null) {
                        try {
                            ((InputStream)reader).close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    if (writer == null) break;
                    try {
                        writer.close();
                    }
                    catch (IOException ignore) {}
                    break;
                }
                File licenseFile = new File(target, url.getFile());
                licenseFile.getParentFile().mkdirs();
                writer = new BufferedOutputStream(new FileOutputStream(licenseFile));
                int b = ((InputStream)reader).read();
                while (b != -1) {
                    writer.write(b);
                    b = ((InputStream)reader).read();
                }
            }
            finally {
                if (reader != null) {
                    try {
                        ((InputStream)reader).close();
                    }
                    catch (IOException ignore) {}
                }
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private void copyJarFiles(File target) throws IOException {
        new File(target, "lib").mkdirs();
        for (Map.Entry<String, File> entry : this.jarFiles.entrySet()) {
            FileUtils.copyFile((File)entry.getValue(), (File)new File(target, entry.getKey()));
        }
    }

    private void copyFiles(File target) throws IOException {
        for (File file : this.files) {
            if (!file.exists()) continue;
            FileUtils.copyFile((File)file, (File)new File(target, file.getPath()));
        }
        for (File dir : this.dirs) {
            this.copyDir(target, dir);
        }
    }

    private void copyDir(File target, File dir) throws IOException {
        File realDir = new File(this.project.getBasedir(), dir.getPath());
        if (realDir.isDirectory()) {
            for (String file : realDir.list()) {
                this.copyDir(target, new File(dir, file));
            }
        } else if (realDir.exists() && !realDir.getName().matches(this.excludes)) {
            File targetFile = new File(target, dir.getPath());
            FileUtils.copyFile((File)realDir, (File)targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        try {
            this.writer.append("end");
        }
        finally {
            this.writer.close();
        }
    }

    void appendList(String name, String list) throws IOException {
        if (list != null) {
            StringBuilder buf = new StringBuilder("[");
            boolean first = true;
            for (String part : list.split(",")) {
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                char quoteChar = part.contains("'") ? (char)'\"' : '\'';
                buf.append(quoteChar).append(part.trim()).append(quoteChar);
            }
            buf.append("]");
            this.appendRaw(name, buf.toString());
        }
    }

    void appendRdocFiles(String extraRdocFiles) throws IOException {
        if (extraRdocFiles != null) {
            for (String f : extraRdocFiles.split(",")) {
                this.appendFile(f.trim());
            }
            this.appendList("extra_rdoc_files", extraRdocFiles);
        }
    }

    void appendFiles(String files) throws IOException {
        if (files != null) {
            for (String f : files.split(",")) {
                this.appendFile(f.trim());
            }
        }
    }
}

