/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.gem.GemArtifact;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class PushMojo
extends AbstractGemMojo {
    protected boolean skip = false;
    protected String pushArgs = null;
    protected File gem;
    protected Object repoSession;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping to push gem");
        } else {
            super.execute();
        }
    }

    public void executeWithGems() throws MojoExecutionException, ScriptException, IOException, MojoFailureException, GemException {
        File f;
        if (this.getJrubyVersion().needsOpenSSL()) {
            this.gemsInstaller.installOpenSSLGem(this.repoSession, this.localRepository, this.getRemoteRepos());
        }
        Script script = this.factory.newScriptFromJRubyJar("gem").addArg("push");
        if (this.project.getArtifact().getFile() == null && (f = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".gem")).exists()) {
            this.project.getArtifact().setFile(f);
        }
        if (this.gem == null && this.project.getArtifact() != null && this.project.getArtifact().getFile() != null && this.project.getArtifact().getFile().exists()) {
            GemArtifact gemArtifact = new GemArtifact(this.project);
            if (!gemArtifact.isGem()) {
                throw new MojoExecutionException("not a gem artifact");
            }
            script.addArg(gemArtifact.getFile());
        } else {
            if (this.gem == null && null == this.args) {
                for (File f2 : this.launchDirectory().listFiles()) {
                    if (!f2.getName().endsWith(".gem")) continue;
                    if (this.gem == null) {
                        this.gem = f2;
                        continue;
                    }
                    throw new MojoFailureException("more than one gem file found, use -Dgem=... to specifiy one");
                }
            }
            if (this.gem != null) {
                this.getLog().info((CharSequence)("use gem: " + this.gem));
                script.addArg(this.gem);
            }
        }
        script.addArgs(this.pushArgs);
        script.addArgs(this.args);
        script.execute();
    }
}

