package de.saumya.mojo.jruby;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on jruby-maven-plugin.<br/> Call <pre>  mvn ruby:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Aug 10 19:44:42 CEST 2014
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "de.saumya.mojo:jruby-maven-plugin:1.0.5", 0 );
        append( sb, "", 0 );

        append( sb, "JRuby Maven Mojo", 0 );
        append( sb, "shared dependencies and plugins for the mojos", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "compile".equals( goal ) )
        {
            append( sb, "ruby:compile", 0 );
            append( sb, "executes the compiles ruby classes to java bytecode (jrubyc).\nNOTE: this goal uses only a small subset of the features of jrubyc.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "args", 2 );
                append( sb, "common arguments\nCommand line -Dargs=...", 3 );
                append( sb, "", 0 );

                append( sb, "env", 2 );
                append( sb, "environment values passed on to the jruby process. needs jrubyFork true.\n", 3 );
                append( sb, "", 0 );

                append( sb, "generatedJavaDirectory (Default: ${basedir}/target/jrubyc-generated-sources)", 2 );
                append( sb, "where the java files (needs >=jruby-1.5).", 3 );
                append( sb, "", 0 );

                append( sb, "generateJava (Default: false)", 2 );
                append( sb, "just generate java classes and add them to the maven source path\nCommand line -Djrubyc.generateJava=...", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreFailures (Default: false)", 2 );
                append( sb, "do not fail the goal\nCommand line -Djrubyc.ignoreFailure=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubycVerbose (Default: false)", 2 );
                append( sb, "verbose jrubyc related output (only with > jruby-1.6.x)\nCommand line -Djrubyc.verbose=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubyFork (Default: true)", 2 );
                append( sb, "fork the JRuby execution.\nCommand line -Djruby.fork=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubyJvmArgs", 2 );
                append( sb, "jvm arguments for the java command executing jruby\nCommand line -Djruby.jvmargs=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubySwitches", 2 );
                append( sb, "switches for the jruby command, like \'--1.9\'\nCommand line -Djruby.switches=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubyVerbose (Default: false)", 2 );
                append( sb, "verbose jruby related output\nCommand line -Djruby.verbose=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubyVersion", 2 );
                append( sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. it overwrites the jruby version from the dependencies if any. i.e. you can easily switch jruby version from the commandline !\ndefault: 1.7.12\nCommand line -Djruby.version=...", 3 );
                append( sb, "", 0 );

                append( sb, "launchDirectory (Default: ${project.basedir})", 2 );
                append( sb, "the launch directory for the JRuby execution.\nCommand line -Djruby.launchDirectory=...", 3 );
                append( sb, "", 0 );

                append( sb, "libDirectory (Default: lib)", 2 );
                append( sb, "directory with ruby sources - added to ruby loadpath only\nCommand line -Djruby.lib=...", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "where the compiled class files are written unless you choose to generate java classes (needs >=jruby-1.5). default is the same as for java classes.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "reference to maven project for internal use.", 3 );
                append( sb, "", 0 );

                append( sb, "rubyDirectory", 2 );
                append( sb, "directory where to find the ruby files", 3 );
                append( sb, "", 0 );

                append( sb, "rubySourceDirectory (Default: src/main/ruby)", 2 );
                append( sb, "directory with ruby sources - added to java classpath and ruby loadpath\nCommand line -Djruby.sourceDirectory=...", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "ruby:help", 0 );
            append( sb, "Display help information on jruby-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0ruby:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jruby".equals( goal ) )
        {
            append( sb, "ruby:jruby", 0 );
            append( sb, "executes the jruby command.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "args", 2 );
                append( sb, "common arguments\nCommand line -Dargs=...", 3 );
                append( sb, "", 0 );

                append( sb, "env", 2 );
                append( sb, "environment values passed on to the jruby process. needs jrubyFork true.\n", 3 );
                append( sb, "", 0 );

                append( sb, "file", 2 );
                append( sb, "ruby file which gets executed.\nCommand line -Djruby.file=...", 3 );
                append( sb, "", 0 );

                append( sb, "filename", 2 );
                append( sb, "ruby file found on search path which gets executed.\nCommand line -Djruby.filename=...", 3 );
                append( sb, "", 0 );

                append( sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2 );
                append( sb, "directory of gem home to use when forking JRuby.\nCommand line -Dgem.home=...", 3 );
                append( sb, "", 0 );

                append( sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2 );
                append( sb, "directory of JRuby path to use when forking JRuby.\nCommand line -Dgem.path=...", 3 );
                append( sb, "", 0 );

                append( sb, "gemUseSystem (Default: false)", 2 );
                append( sb, "use system gems instead of setting up GemPath/GemHome inside the build directory and ignores any set gemHome and gemPath. you need to have both GEM_HOME and GEM_PATH environment variable set to make it work.\nCommand line -Dgem.useSystem=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubyArgs", 2 );
                append( sb, "arguments for the jruby command.\nCommand line -Djruby.args=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubyFork (Default: true)", 2 );
                append( sb, "fork the JRuby execution.\nCommand line -Djruby.fork=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubyJvmArgs", 2 );
                append( sb, "jvm arguments for the java command executing jruby\nCommand line -Djruby.jvmargs=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubySwitches", 2 );
                append( sb, "switches for the jruby command, like \'--1.9\'\nCommand line -Djruby.switches=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubyVerbose (Default: false)", 2 );
                append( sb, "verbose jruby related output\nCommand line -Djruby.verbose=...", 3 );
                append( sb, "", 0 );

                append( sb, "jrubyVersion", 2 );
                append( sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. it overwrites the jruby version from the dependencies if any. i.e. you can easily switch jruby version from the commandline !\ndefault: 1.7.12\nCommand line -Djruby.version=...", 3 );
                append( sb, "", 0 );

                append( sb, "launchDirectory (Default: ${project.basedir})", 2 );
                append( sb, "the launch directory for the JRuby execution.\nCommand line -Djruby.launchDirectory=...", 3 );
                append( sb, "", 0 );

                append( sb, "libDirectory (Default: lib)", 2 );
                append( sb, "directory with ruby sources - added to ruby loadpath only\nCommand line -Djruby.lib=...", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "output file where the standard out will be written\nCommand line -Djruby.outputFile=...", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "reference to maven project for internal use.", 3 );
                append( sb, "", 0 );

                append( sb, "rubySourceDirectory (Default: src/main/ruby)", 2 );
                append( sb, "directory with ruby sources - added to java classpath and ruby loadpath\nCommand line -Djruby.sourceDirectory=...", 3 );
                append( sb, "", 0 );

                append( sb, "script", 2 );
                append( sb, "ruby code which gets executed.\nCommand line -Djruby.script=...", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
