/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.jruby;

import de.saumya.mojo.jruby.JRubyVersion;
import de.saumya.mojo.jruby.MojoLogger;
import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.NoSuchRealmException;

public abstract class AbstractJRubyMojo
extends AbstractMojo {
    protected static final String JRUBY_COMPLETE = "jruby-complete";
    protected static final String JRUBY_CORE = "jruby-core";
    protected static final String JRUBY_STDLIB = "jruby-stdlib";
    protected static final String DEFAULT_JRUBY_VERSION = "1.7.12";
    protected String args;
    protected String jrubyJvmArgs;
    protected String jrubySwitches;
    protected Map<String, String> env;
    private String jrubyVersion;
    protected boolean jrubyFork;
    protected boolean jrubyVerbose;
    protected File rubySourceDirectory;
    protected File libDirectory;
    private File launchDirectory;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected ClassRealm classRealm;
    protected RepositorySystem repositorySystem;
    protected Logger logger;
    protected ScriptFactory factory;
    private JRubyVersion jRubyVersion;

    protected JRubyVersion getJrubyVersion() {
        if (this.jRubyVersion == null) {
            this.jRubyVersion = new JRubyVersion(this.jrubyVersion == null ? DEFAULT_JRUBY_VERSION : this.jrubyVersion);
        }
        return this.jRubyVersion;
    }

    private ScriptFactory newScriptFactory() throws MojoExecutionException {
        ScriptFactory factory = this.createScriptFactory();
        if (this.env != null) {
            for (Map.Entry<String, String> entry : this.env.entrySet()) {
                factory.addEnv(entry.getKey(), entry.getValue());
            }
        }
        return factory;
    }

    private ScriptFactory createScriptFactory() throws MojoExecutionException {
        try {
            this.classRealm.getWorld().disposeRealm("jruby-all");
        }
        catch (NoSuchRealmException ignore) {
            // empty catch block
        }
        try {
            ClassRealm realm = this.classRealm.getWorld().newRealm("jruby-all");
            for (String path : this.project.getTestClasspathElements()) {
                realm.addConstituent(new File(path).toURI().toURL());
            }
            if (this.jrubyVersion != null) {
                return this.newScriptFactory(this.resolveJRubyCompleteArtifact(this.jrubyVersion));
            }
            Class clazz = realm.loadClass("org.jruby.runtime.Constants");
            if (this.jrubyVerbose) {
                String version = clazz.getField("VERSION").get(clazz).toString();
                this.getLog().info((CharSequence)"found jruby on classpath");
                this.getLog().info((CharSequence)("jruby version   : " + version));
            }
            this.classRealm = realm;
            return this.newScriptFactory(null);
        }
        catch (Exception e) {
            try {
                return this.newScriptFactory(this.resolveJRubyArtifact());
            }
            catch (DependencyResolutionRequiredException ee) {
                throw new MojoExecutionException("could not resolve jruby", e);
            }
        }
    }

    protected ScriptFactory newScriptFactory(Artifact artifact) throws MojoExecutionException {
        try {
            ScriptFactory factory;
            ScriptFactory scriptFactory = artifact == null ? new ScriptFactory(this.logger, this.classRealm, null, this.project.getTestClasspathElements(), this.jrubyFork) : (factory = JRUBY_CORE.equals(artifact.getArtifactId()) ? new ScriptFactory(this.logger, this.classRealm, artifact.getFile(), this.resolveJRubyStdlibArtifact(artifact).getFile(), this.project.getTestClasspathElements(), this.jrubyFork) : new ScriptFactory(this.logger, this.classRealm, artifact.getFile(), this.project.getTestClasspathElements(), this.jrubyFork));
            if (this.libDirectory != null && this.libDirectory.exists()) {
                if (this.jrubyVerbose) {
                    this.getLog().info((CharSequence)("add to ruby loadpath: " + this.libDirectory.getAbsolutePath()));
                }
                factory.addSwitch("-I", this.libDirectory.getAbsolutePath());
            }
            if (this.rubySourceDirectory != null && this.rubySourceDirectory.exists()) {
                if (this.jrubyVerbose) {
                    this.getLog().info((CharSequence)("add to ruby loadpath: " + this.rubySourceDirectory.getAbsolutePath()));
                }
                factory.addSwitch("-I", this.rubySourceDirectory.getAbsolutePath());
            }
            return factory;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("could not resolve jruby", (Exception)((Object)e));
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        System.setProperty("jbundle.skip", "true");
        this.logger = new MojoLogger(this.jrubyVerbose, this.getLog());
        this.factory = this.newScriptFactory();
        this.factory.addEnv("JBUNDLE_SKIP", "true");
        this.factory.addEnv("JARS_SKIP", "true");
        this.factory.addJvmArgs(this.jrubyJvmArgs);
        this.factory.addSwitches(this.jrubySwitches);
        if (this.rubySourceDirectory != null && this.rubySourceDirectory.exists()) {
            if (this.jrubyVerbose) {
                this.getLog().info((CharSequence)("add to java classpath: " + this.rubySourceDirectory.getAbsolutePath()));
            }
            Resource resource = new Resource();
            resource.setDirectory(this.rubySourceDirectory.getAbsolutePath());
            this.project.getBuild().getResources().add(resource);
        }
        try {
            this.executeJRuby();
        }
        catch (IOException e) {
            throw new MojoExecutionException("error in executing jruby", (Exception)e);
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("error in executing jruby", (Exception)((Object)e));
        }
    }

    protected abstract void executeJRuby() throws MojoExecutionException, MojoFailureException, IOException, ScriptException;

    protected File launchDirectory() {
        if (this.launchDirectory == null) {
            this.launchDirectory = this.project.getBasedir();
            if (this.launchDirectory == null || !this.launchDirectory.exists()) {
                this.launchDirectory = new File(System.getProperty("user.dir"));
            }
        }
        return this.launchDirectory;
    }

    protected Artifact resolveJRubyCompleteArtifact(String version) throws DependencyResolutionRequiredException {
        this.getLog().debug((CharSequence)("resolve jruby for version " + version));
        Artifact artifact = this.repositorySystem.createArtifact("org.jruby", JRUBY_COMPLETE, version, "jar");
        return this.resolveJRubyArtifact(artifact);
    }

    private Artifact resolveJRubyArtifact(Artifact artifact) throws DependencyResolutionRequiredException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        this.repositorySystem.resolve(request);
        if (this.jrubyVerbose) {
            this.getLog().info((CharSequence)("jruby version   : " + artifact.getVersion()));
        }
        this.jrubyVersion = artifact.getVersion();
        return artifact;
    }

    protected Artifact resolveJRubyArtifact() throws DependencyResolutionRequiredException, MojoExecutionException {
        if (this.jrubyVersion != null) {
            return this.resolveJRubyCompleteArtifact(this.jrubyVersion);
        }
        for (Dependency artifact : this.project.getDependencies()) {
            if (!artifact.getArtifactId().equals(JRUBY_COMPLETE) && !artifact.getArtifactId().equals(JRUBY_CORE) || artifact.getScope().equals("provided") || artifact.getScope().equals("system")) continue;
            return this.resolveJRubyArtifact(this.repositorySystem.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType()));
        }
        return this.resolveJRubyCompleteArtifact(DEFAULT_JRUBY_VERSION);
    }

    protected Artifact resolveJRubyStdlibArtifact(Artifact jruby) throws DependencyResolutionRequiredException, MojoExecutionException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        for (Dependency artifact : this.project.getDependencies()) {
            if (!artifact.getArtifactId().equals(JRUBY_STDLIB) || artifact.getScope().equals("provided") || artifact.getScope().equals("system")) continue;
            request.setArtifact(this.repositorySystem.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType()));
            break;
        }
        if (request.getArtifact() == null) {
            request.setResolveTransitively(true);
            request.setArtifact(jruby);
        }
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        Set set = this.repositorySystem.resolve(request).getArtifacts();
        for (Artifact a : set) {
            if (!JRUBY_STDLIB.equals(a.getArtifactId())) continue;
            return a;
        }
        throw new MojoExecutionException("failed to resolve jruby stdlib artifact");
    }
}

