/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.jruby;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "de.saumya.mojo:jruby-maven-plugin:1.0.7", 0);
        this.append(sb, "", 0);
        this.append(sb, "JRuby Maven Mojo", 0);
        this.append(sb, "shared dependencies and plugins for the mojos", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile".equals(this.goal)) {
            this.append(sb, "ruby:compile", 0);
            this.append(sb, "executes the compiles ruby classes to java bytecode (jrubyc).\nNOTE: this goal uses only a small subset of the features of jrubyc.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments\nCommand line -Dargs=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "env", 2);
                this.append(sb, "environment values passed on to the jruby process. needs jrubyFork true.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedJavaDirectory (Default: ${basedir}/target/jrubyc-generated-sources)", 2);
                this.append(sb, "where the java files (needs >=jruby-1.5).", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateJava (Default: false)", 2);
                this.append(sb, "just generate java classes and add them to the maven source path\nCommand line -Djrubyc.generateJava=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "do not fail the goal\nCommand line -Djrubyc.ignoreFailure=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubycVerbose (Default: false)", 2);
                this.append(sb, "verbose jrubyc related output (only with > jruby-1.6.x)\nCommand line -Djrubyc.verbose=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.\nCommand line -Djruby.fork=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "jvm arguments for the java command executing jruby\nCommand line -Djruby.jvmargs=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command, like '--1.9'\nCommand line -Djruby.switches=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output\nCommand line -Djruby.verbose=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. it overwrites the jruby version from the dependencies if any. i.e. you can easily switch jruby version from the commandline !\ndefault: 1.7.12\nCommand line -Djruby.version=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${project.basedir})", 2);
                this.append(sb, "the launch directory for the JRuby execution.\nCommand line -Djruby.launchDirectory=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: lib)", 2);
                this.append(sb, "directory with ruby sources - added to ruby loadpath only\nCommand line -Djruby.lib=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "where the compiled class files are written unless you choose to generate java classes (needs >=jruby-1.5). default is the same as for java classes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rubyDirectory", 2);
                this.append(sb, "directory where to find the ruby files", 3);
                this.append(sb, "", 0);
                this.append(sb, "rubySourceDirectory (Default: src/main/ruby)", 2);
                this.append(sb, "directory with ruby sources - added to java classpath and ruby loadpath\nCommand line -Djruby.sourceDirectory=...", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "ruby:help", 0);
            this.append(sb, "Display help information on jruby-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0ruby:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jruby".equals(this.goal)) {
            this.append(sb, "ruby:jruby", 0);
            this.append(sb, "executes the jruby command.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments\nCommand line -Dargs=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "env", 2);
                this.append(sb, "environment values passed on to the jruby process. needs jrubyFork true.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "file", 2);
                this.append(sb, "ruby file which gets executed.\nCommand line -Djruby.file=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "filename", 2);
                this.append(sb, "ruby file found on search path which gets executed.\nCommand line -Djruby.filename=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.\nCommand line -Dgem.home=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.\nCommand line -Dgem.path=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemUseSystem (Default: false)", 2);
                this.append(sb, "use system gems instead of setting up GemPath/GemHome inside the build directory and ignores any set gemHome and gemPath. you need to have both GEM_HOME and GEM_PATH environment variable set to make it work.\nCommand line -Dgem.useSystem=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs", 2);
                this.append(sb, "arguments for the jruby command.\nCommand line -Djruby.args=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.\nCommand line -Djruby.fork=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "jvm arguments for the java command executing jruby\nCommand line -Djruby.jvmargs=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command, like '--1.9'\nCommand line -Djruby.switches=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output\nCommand line -Djruby.verbose=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. it overwrites the jruby version from the dependencies if any. i.e. you can easily switch jruby version from the commandline !\ndefault: 1.7.12\nCommand line -Djruby.version=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${project.basedir})", 2);
                this.append(sb, "the launch directory for the JRuby execution.\nCommand line -Djruby.launchDirectory=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: lib)", 2);
                this.append(sb, "directory with ruby sources - added to ruby loadpath only\nCommand line -Djruby.lib=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile", 2);
                this.append(sb, "output file where the standard out will be written\nCommand line -Djruby.outputFile=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rubySourceDirectory (Default: src/main/ruby)", 2);
                this.append(sb, "directory with ruby sources - added to java classpath and ruby loadpath\nCommand line -Djruby.sourceDirectory=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "script", 2);
                this.append(sb, "ruby code which gets executed.\nCommand line -Djruby.script=...", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

