/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.minitest;

import de.saumya.mojo.jruby.JRubyVersion;
import de.saumya.mojo.minitest.MinitestMavenTestScriptFactory;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import de.saumya.mojo.tests.AbstractTestMojo;
import de.saumya.mojo.tests.JRubyRun;
import de.saumya.mojo.tests.TestResultManager;
import de.saumya.mojo.tests.TestScriptFactory;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="spec", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class MinispecMojo
extends AbstractTestMojo {
    @Parameter(property="minipec.dir", defaultValue="spec/**/*_spec.rb")
    private String minispecDirectory = null;
    @Parameter(property="minipec.args")
    private String minispecArgs = null;
    @Parameter(property="skipMinispecs", defaultValue="false")
    protected boolean skipMinispecs;
    private TestResultManager resultManager;
    private File outputfile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests || this.skipMinispecs) {
            this.getLog().info((CharSequence)"Skipping Minispecs");
            return;
        }
        this.outputfile = new File(this.project.getBuild().getDirectory().replace("${project.basedir}/", ""), "minispec.txt");
        if (this.outputfile.exists()) {
            this.outputfile.delete();
        }
        this.resultManager = new TestResultManager(this.project.getName(), "minispec", this.testReportDirectory, this.summaryReport);
        super.execute();
    }

    protected JRubyRun.Result runIt(ScriptFactory factory, JRubyVersion.Mode mode, JRubyVersion version, TestScriptFactory scriptFactory) throws IOException, ScriptException, MojoExecutionException {
        scriptFactory.setOutputDir(this.outputfile.getParentFile());
        scriptFactory.setReportPath(this.outputfile);
        if (this.minispecDirectory.startsWith(this.launchDirectory().getAbsolutePath())) {
            scriptFactory.setSourceDir(new File(this.minispecDirectory));
        } else {
            scriptFactory.setSourceDir(new File(this.launchDirectory(), this.minispecDirectory));
        }
        Script script = factory.newScript(scriptFactory.getCoreScript());
        if (this.minispecArgs != null) {
            script.addArgs(this.minispecArgs);
        }
        if (this.args != null) {
            script.addArgs(this.args);
        }
        try {
            script.executeIn(this.launchDirectory());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"exception in running specs", (Throwable)e);
        }
        return this.resultManager.generateReports(mode, version, this.outputfile);
    }

    protected TestScriptFactory newTestScriptFactory() {
        return new MinitestMavenTestScriptFactory();
    }
}

