/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rubygems;

import java.util.Arrays;
import org.sonatype.nexus.ruby.Directory;

public class HtmlDirectoryBuilder {
    private StringBuilder html = new StringBuilder("<!DOCTYPE html>\n");

    public HtmlDirectoryBuilder(String root, Directory file) {
        this.buildHeader(root + file.remotePath());
        Object[] items = file.getItems();
        Arrays.sort(items);
        this.build((String[])items);
        this.buildFooter();
    }

    public String toHTML() {
        return this.html.toString();
    }

    public void buildHeader(String title) {
        this.html.append("<html>\n");
        this.html.append("  <header>\n");
        this.html.append("    <title>").append(title).append("</title>\n");
        this.html.append("  </header>\n");
        this.html.append("  <body>\n");
        this.html.append("    <h1>Index of ").append(title).append("</h1>\n");
        this.html.append("    <hr />\n");
        this.html.append("    <a href=\"..\">../</a><br />\n");
    }

    public void buildFooter() {
        this.html.append("  <hr />\n");
        this.html.append("  </body>\n");
        this.html.append("</html>\n");
    }

    public void build(String ... items) {
        for (String item : items) {
            this.buildLink(item);
        }
    }

    public void buildLink(String name) {
        this.html.append("    <a href=\"").append(name).append("\">").append(name).append("</a><br />\n");
    }
}

