/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rubygems;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.sonatype.nexus.ruby.DependencyFile;
import org.sonatype.nexus.ruby.DependencyHelper;
import org.sonatype.nexus.ruby.Directory;
import org.sonatype.nexus.ruby.IOUtil;
import org.sonatype.nexus.ruby.MergeSpecsHelper;
import org.sonatype.nexus.ruby.RubygemsFile;
import org.sonatype.nexus.ruby.RubygemsGateway;
import org.sonatype.nexus.ruby.SpecsIndexType;
import org.sonatype.nexus.ruby.SpecsIndexZippedFile;
import org.sonatype.nexus.ruby.layout.SimpleStorage;
import org.sonatype.nexus.ruby.layout.Storage;

public class MergedSimpleStorage
extends SimpleStorage {
    private final List<Storage> storages;
    private final RubygemsGateway gateway;

    MergedSimpleStorage(RubygemsGateway gateway, List<Storage> storages) {
        super(null);
        this.gateway = gateway;
        this.storages = storages;
    }

    public InputStream getInputStream(RubygemsFile file) throws IOException {
        if (file.hasException()) {
            throw new IOException(file.getException());
        }
        if (file.get() == null) {
            for (Storage s : this.storages) {
                s.retrieve(file);
                if (file.exists()) {
                    return s.getInputStream(file);
                }
                file.resetState();
            }
        }
        return super.getInputStream(file);
    }

    public String[] listDirectory(Directory dir) {
        return new String[0];
    }

    public void retrieve(RubygemsFile file) {
        for (Storage s : this.storages) {
            file.resetState();
            s.retrieve(file);
            if (!file.exists()) continue;
            return;
        }
    }

    public void retrieve(DependencyFile file) {
        DependencyHelper deps = this.gateway.newDependencyHelper();
        try {
            for (Storage s : this.storages) {
                s.retrieve(file);
                if (file.exists()) {
                    try (InputStream is = s.getInputStream((RubygemsFile)file);){
                        deps.add(is);
                    }
                }
                file.resetState();
            }
            file.resetState();
            this.memory(deps.getInputStream(false), (RubygemsFile)file);
        }
        catch (IOException e) {
            file.setException((Exception)e);
        }
    }

    public void retrieve(SpecsIndexZippedFile file) {
        MergeSpecsHelper merge = this.gateway.newMergeSpecsHelper();
        try {
            for (Storage s : this.storages) {
                s.retrieve(file);
                if (file.exists()) {
                    try (GZIPInputStream is = new GZIPInputStream(s.getInputStream((RubygemsFile)file));){
                        merge.add((InputStream)is);
                    }
                }
                file.resetState();
            }
            this.memory(IOUtil.toGzipped((InputStream)merge.getInputStream(file.specsType() == SpecsIndexType.LATEST)), (RubygemsFile)file);
        }
        catch (IOException e) {
            file.setException((Exception)e);
        }
    }
}

