/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rubygems;

import de.saumya.mojo.rubygems.HtmlDirectoryBuilder;
import de.saumya.mojo.rubygems.RubygemsServlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.nexus.ruby.Directory;
import org.sonatype.nexus.ruby.FileType;
import org.sonatype.nexus.ruby.GemArtifactFile;
import org.sonatype.nexus.ruby.IOUtil;
import org.sonatype.nexus.ruby.RubygemsFile;
import org.sonatype.nexus.ruby.cuba.RubygemsFileSystem;
import org.sonatype.nexus.ruby.layout.Storage;

public class RubygemsServlet
extends HttpServlet {
    private static final long serialVersionUID = -6942659125767757561L;
    RubygemsFileSystem fileSystem;
    Storage storage;
    String proxyUrl;

    @Override
    public void init() throws ServletException {
        super.init();
        String name = this.getServletConfig().getServletName();
        this.fileSystem = (RubygemsFileSystem)this.getServletContext().getAttribute(name + "/" + RubygemsFileSystem.class.getName());
        this.storage = (Storage)this.getServletContext().getAttribute(name + "/" + Storage.class.getName());
        URL url = (URL)this.getServletContext().getAttribute(name + "/" + URL.class.getName());
        this.proxyUrl = url == null ? null : url.toString();
    }

    protected void handle(HttpServletRequest req, HttpServletResponse resp, RubygemsFile file) throws IOException, ServletException {
        this.log(this.getPathInfo(req) + " - " + file);
        block0 : switch (1.$SwitchMap$org$sonatype$nexus$ruby$RubygemsFile$State[file.state().ordinal()]) {
            case 1: {
                resp.sendError(403);
                break;
            }
            case 2: {
                resp.sendError(404);
                break;
            }
            case 3: {
                switch (1.$SwitchMap$org$sonatype$nexus$ruby$FileType[file.type().ordinal()]) {
                    case 1: {
                        if (req.getPathInfo() == null || !req.getPathInfo().endsWith("/")) {
                            resp.sendRedirect(req.getRequestURI() + "/");
                            return;
                        }
                        this.writeOutDirectory(resp, (Directory)file);
                        break block0;
                    }
                    case 2: {
                        resp.sendRedirect(this.proxyUrl + "/gems/" + ((GemArtifactFile)file).gem(null).filename() + ".gem");
                        return;
                    }
                    case 3: {
                        resp.sendRedirect(this.proxyUrl + file.remotePath());
                        return;
                    }
                }
                resp.sendError(404, req.getRequestURI() + " has no view - not implemented");
                break;
            }
            case 4: {
                throw new ServletException(file.getException());
            }
            case 5: {
                resp.setHeader("Retry-After", "120");
                resp.sendError(503);
                break;
            }
            case 6: {
                resp.setContentType(file.type().mime());
                if (file.type().encoding() != null) {
                    resp.setCharacterEncoding(file.type().encoding());
                }
                if (file.type().isVaryAccept()) {
                    resp.setHeader("Vary", "Accept");
                }
                IOUtil.copy((InputStream)this.storage.getInputStream(file), (OutputStream)resp.getOutputStream());
                break;
            }
            case 7: {
                throw new ServletException("BUG: should never reach here");
            }
        }
    }

    private void writeOutDirectory(HttpServletResponse resp, Directory file) throws IOException {
        HtmlDirectoryBuilder html = new HtmlDirectoryBuilder(this.getServletConfig().getServletName(), file);
        resp.setContentType("text/html");
        resp.setCharacterEncoding("utf-8");
        resp.getWriter().print(html.toHTML());
    }

    private String getPathInfo(HttpServletRequest req) {
        String path = req.getPathInfo();
        if (path == null) {
            return "";
        }
        return path;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.fileSystem == null) {
            resp.sendError(503, "not configured to server requests - maybe wrong base-URL !?");
        } else {
            super.service(req, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RubygemsFile file = this.fileSystem.get(this.getPathInfo(req), req.getQueryString());
        if (file.type() == FileType.API_V1 && "api_key".equals(file.name())) {
            this.log(this.getPathInfo(req));
            resp.getOutputStream().print("behappy");
            resp.setContentLength(7);
            resp.setContentType("text/plain");
        } else {
            this.handle(req, resp, file);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RubygemsFile file = this.fileSystem.post((InputStream)req.getInputStream(), this.getPathInfo(req));
        if (file.hasException()) {
            this.handle(req, resp, file);
        } else {
            this.log(this.getPathInfo(req) + " - " + file);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RubygemsFile file = this.fileSystem.delete(this.getPathInfo(req));
        if (file.hasException()) {
            this.handle(req, resp, file);
        } else {
            this.log(this.getPathInfo(req) + " - " + file);
        }
    }
}

