/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.mains;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.LinkedList;
import java.util.List;
import org.jruby.mains.Config;

public abstract class AbstractLauncher {
    void launch(String ... args) throws Exception {
        LinkedList<URL> urls = new LinkedList<URL>();
        Config config = this.processJar(this.jarLocation(), urls);
        this.launchIt(urls, config, args);
    }

    abstract Config processJar(URL var1, List<URL> var2) throws IOException;

    URL jarLocation() {
        ProtectionDomain protectionDomain = AbstractLauncher.class.getProtectionDomain();
        return protectionDomain.getCodeSource().getLocation();
    }

    void launchIt(List<URL> classloaderUrls, Config config, String ... args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException {
        try (URLClassLoader loader = new URLClassLoader(classloaderUrls.toArray(new URL[classloaderUrls.size()]), ClassLoader.getSystemClassLoader().getParent());){
            Class<?> main = loader.loadClass("org.jruby.mains.JRubyMain");
            Method m = main.getMethod("main", String.class, String.class, String.class, args.getClass());
            m.invoke(main, config.bundleDisableSharedGems, config.workingDirectory, config.jrubyHome, args);
        }
    }
}

