/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.mains;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtractedZip {
    private final File target;
    private final List<URL> urls = new LinkedList<URL>();
    private final byte[] bytesIn = new byte[4096];

    public ExtractedZip(InputStream zip) throws IOException {
        this(zip, false);
    }

    public ExtractedZip(InputStream zip, boolean onlyWebInfLibJars) throws IOException {
        this.target = Files.createTempDirectory("jruby-mains-", new FileAttribute[0]).toFile();
        if (onlyWebInfLibJars) {
            this.unzipOnlyJars(zip);
        } else {
            this.unzip(zip);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Files.walkFileTree(ExtractedZip.this.target.toPath(), new DeleteDirectory());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    File directory() {
        return this.target;
    }

    List<URL> urls() {
        return this.urls;
    }

    private void unzipOnlyJars(InputStream zip) throws IOException {
        try (ZipInputStream is = new ZipInputStream(zip);){
            ZipEntry entry = is.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().startsWith("WEB-INF/lib/") && entry.getName().endsWith(".jar")) {
                    File path = new File(this.target, entry.getName());
                    this.extractFile(is, path);
                    this.urls.add(path.toURI().toURL());
                }
                is.closeEntry();
                entry = is.getNextEntry();
            }
        }
    }

    private void unzip(InputStream zip) throws IOException {
        try (ZipInputStream is = new ZipInputStream(zip);){
            ZipEntry entry = is.getNextEntry();
            while (entry != null) {
                File path = new File(this.target, entry.getName());
                if (!entry.isDirectory()) {
                    this.extractFile(is, path);
                } else {
                    path.mkdir();
                }
                is.closeEntry();
                entry = is.getNextEntry();
            }
        }
    }

    private void extractFile(ZipInputStream in, File path) throws IOException {
        path.getParentFile().mkdirs();
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));){
            int read = 0;
            while ((read = in.read(this.bytesIn)) != -1) {
                bos.write(this.bytesIn, 0, read);
            }
        }
        if (path.getPath().contains("jruby.home/bin")) {
            path.setExecutable(true);
        }
    }

    static class DeleteDirectory
    extends SimpleFileVisitor<Path> {
        DeleteDirectory() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

