/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.mains;

import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Properties;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jruby.mains.JettyStop;
import org.jruby.mains.WarMain;

public class JettyRunMain {
    public static void main(String ... args) throws Exception {
        if (args.length == 0) {
            JettyRunMain.main(System.getProperties());
        } else {
            WarMain.main(args);
        }
    }

    public static void main(Properties props) {
        Server server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setMaxIdleTime(3600000);
        connector.setSoLingerTime(-1);
        connector.setPort(Integer.parseInt(props.getProperty("port", "8989")));
        connector.setHost(props.getProperty("host"));
        server.setConnectors(new Connector[]{connector});
        WebAppContext context = new WebAppContext();
        context.setServer(server);
        context.setContextPath("/");
        context.setExtractWAR(false);
        context.setCopyWebInf(true);
        ProtectionDomain protectionDomain = JettyRunMain.class.getProtectionDomain();
        URL location = protectionDomain.getCodeSource().getLocation();
        context.setWar(location.toExternalForm());
        server.setHandler(context);
        Runtime.getRuntime().addShutdownHook(new JettyStop(server));
        try {
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }
}

