/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.tests;

import de.saumya.mojo.jruby.JRubyVersion;
import java.util.ArrayList;

public class JRubyRun {
    public final JRubyVersion.Mode[] modes;
    public final JRubyVersion version;
    public final boolean isDefaultModeOnly;
    final Result[] results = new Result[JRubyVersion.Mode.values().length];

    private static JRubyVersion.Mode[] filter(JRubyVersion version, JRubyVersion.Mode[] modes) {
        ArrayList<JRubyVersion.Mode> result = new ArrayList<JRubyVersion.Mode>();
        for (JRubyVersion.Mode m : modes) {
            if (!version.hasMode(m)) continue;
            result.add(m);
        }
        return result.toArray(new JRubyVersion.Mode[result.size()]);
    }

    public JRubyRun(JRubyVersion version) {
        this(true, version, version.defaultMode());
    }

    public JRubyRun(JRubyVersion version, JRubyVersion.Mode ... modes) {
        this(false, version, modes);
    }

    public JRubyRun(boolean isDefault, JRubyVersion version, JRubyVersion.Mode ... modes) {
        JRubyVersion.Mode[] modeArray;
        if (modes.length == 0) {
            JRubyVersion.Mode[] modeArray2 = new JRubyVersion.Mode[1];
            modeArray = modeArray2;
            modeArray2[0] = version.defaultMode();
        } else {
            modeArray = JRubyRun.filter(version, modes);
        }
        this.modes = modeArray;
        this.version = version;
        this.isDefaultModeOnly = isDefault;
    }

    public Result result(JRubyVersion.Mode mode) {
        return this.results[mode.ordinal()];
    }

    public void setResult(JRubyVersion.Mode mode, Result result) {
        this.results[mode == null ? this.version.defaultMode().ordinal() : mode.ordinal()] = result;
    }

    public String toString(JRubyVersion.Mode mode) {
        Result result = this.result(mode);
        return "jruby-" + this.version + " mode " + mode + ": " + result.message;
    }

    public static class Result {
        public boolean success;
        public String message;
    }
}

