/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.focusfx;

import de.saxsys.focusfx.DefaultFocusTraversalPolicy;
import de.saxsys.focusfx.EventTuple;
import de.saxsys.focusfx.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;

public class FXFocusManager {
    static final String IMPL_TRAVERSAL_FOR_PARENT = "IMPL_TRAVERSAL_FOR_PARENT";
    static final String IMPL_FOCUS_NODES_LIST_PROPERTY = "FOCUS_NODES";
    static final String IMPL_CONTAINER_BEFORE = "FOCUS_NODE_BEFORE";
    static final String IMPL_CONTAINER_AFTER = "FOCUS_FOLLOWING_NODE";

    public static void applyDefaultPolicy(Parent parent) {
        FXFocusManager.checkConfiguration(parent);
        DefaultFocusTraversalPolicy focusTraversalPolicy = new DefaultFocusTraversalPolicy(FXFocusManager.getFocusNodes(parent));
        ArrayList<EventTuple> forwardEvents = new ArrayList<EventTuple>();
        ArrayList<EventTuple> backwardEvents = new ArrayList<EventTuple>();
        forwardEvents.add(EventTuple.TAB_FORWARD);
        backwardEvents.add(EventTuple.SHIFT_TAB_BACKWARDS);
        FXFocusManager.applyFocusTraversalPolicy(focusTraversalPolicy, parent, forwardEvents, backwardEvents);
        Platform.runLater(() -> FXFocusManager.getTraversalPolicyForParent(parent).getFirstNode(parent).requestFocus());
    }

    public static void applyFocusTraversalPolicy(FocusTraversalPolicy traversal, Parent parent, List<EventTuple> forwardEvents, List<EventTuple> backEvents) {
        FXFocusManager.checkConfiguration(parent);
        parent.getProperties().put((Object)IMPL_TRAVERSAL_FOR_PARENT, (Object)traversal);
        ObservableList<Node> focusNodes = FXFocusManager.getFocusNodes(parent);
        focusNodes.addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().forEach(n -> {
                    forwardEvents.forEach(tuple -> FXFocusManager.applyForwardFocusHandling(traversal, parent, n, tuple));
                    backEvents.forEach(tuple -> FXFocusManager.applyBackwardFocusHandling(traversal, parent, n, tuple));
                });
            }
        });
        focusNodes.forEach(node -> {
            forwardEvents.forEach(tuple -> FXFocusManager.applyForwardFocusHandling(traversal, parent, node, tuple));
            backEvents.forEach(tuple -> FXFocusManager.applyBackwardFocusHandling(traversal, parent, node, tuple));
        });
    }

    public static void setFocusOrder(Parent node, ObservableList<Node> nodes) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null. This is forbidden.");
        }
        if (nodes.size() < 1) {
            throw new IllegalArgumentException("Put more then 1 node for a focuschain");
        }
        node.getProperties().put((Object)IMPL_FOCUS_NODES_LIST_PROPERTY, nodes);
    }

    public static void setFocusOrderToChildrenRank(Parent parent) {
        FXFocusManager.setFocusOrder(parent, (ObservableList<Node>)parent.getChildrenUnmodifiable());
    }

    public static void setParentTraversalChain(Parent ... parents) {
        if (parents.length < 2) {
            throw new IllegalArgumentException("Put more then 1 node for a focuschain");
        }
        for (int i = 0; i < parents.length; ++i) {
            if (FXFocusManager.getTraversalPolicyForParent(parents[i]) == null) {
                throw new IllegalStateException("One of the Nodes in the chain has no Focus enabled. Use the applyFocus... functions.");
            }
            if (i + 1 < parents.length) {
                parents[i].getProperties().put((Object)IMPL_CONTAINER_AFTER, (Object)parents[i + 1]);
            }
            if (i <= 0) continue;
            parents[i].getProperties().put((Object)IMPL_CONTAINER_BEFORE, (Object)parents[i - 1]);
        }
        Platform.runLater(() -> FXFocusManager.getTraversalPolicyForParent(parents[0]).getFirstNode(parents[0]).requestFocus());
    }

    private static void applyForwardFocusHandling(FocusTraversalPolicy traversal, Parent parent, Node node, EventTuple tuple) {
        node.addEventFilter(tuple.getEvent(), event -> {
            if (tuple.getCheck().test(event)) {
                event.consume();
                if (FXFocusManager.checkAndMoveToNextContainer(traversal, parent, node)) {
                    return;
                }
                Node nodeAfter = traversal.getNodeAfter(parent, node);
                while (!nodeAfter.isFocusTraversable()) {
                    nodeAfter = traversal.getNodeAfter(parent, nodeAfter);
                }
                nodeAfter.requestFocus();
            }
        });
    }

    private static void applyBackwardFocusHandling(FocusTraversalPolicy traversal, Parent parent, Node node, EventTuple tuple) {
        node.addEventFilter(tuple.getEvent(), event -> {
            if (tuple.getCheck().test(event)) {
                event.consume();
                if (FXFocusManager.checkAndMoveToBeforeContainer(traversal, parent, node)) {
                    return;
                }
                Node nodeBefore = traversal.getNodeBefore(parent, node);
                while (!nodeBefore.isFocusTraversable()) {
                    nodeBefore = traversal.getNodeBefore(parent, nodeBefore);
                }
                nodeBefore.requestFocus();
            }
        });
    }

    private static boolean checkAndMoveToNextContainer(FocusTraversalPolicy traversal, Parent parent, Node node) {
        Parent nextContainer = FXFocusManager.getContainerAfter(parent);
        if (node == traversal.getLastNode(parent) && nextContainer != null) {
            FXFocusManager.getTraversalPolicyForParent(nextContainer).getFirstNode(nextContainer).requestFocus();
            return true;
        }
        return false;
    }

    private static boolean checkAndMoveToBeforeContainer(FocusTraversalPolicy traversal, Parent parent, Node node) {
        Parent beforeContainer = FXFocusManager.getContainerBefore(parent);
        if (node == traversal.getFirstNode(parent) && beforeContainer != null) {
            FocusTraversalPolicy focusTraversalPolicy = FXFocusManager.getTraversalPolicyForParent(beforeContainer);
            focusTraversalPolicy.getLastNode(beforeContainer).requestFocus();
            return true;
        }
        return false;
    }

    private static FocusTraversalPolicy getTraversalPolicyForParent(Parent container) {
        return (FocusTraversalPolicy)container.getProperties().get((Object)IMPL_TRAVERSAL_FOR_PARENT);
    }

    private static void checkConfiguration(Parent parent) {
        ObservableList<Node> nodes = FXFocusManager.getFocusNodes(parent);
        if (nodes == null) {
            throw new IllegalArgumentException("Use FXFocusManager.focusNodes(...) before you use the Focustraversal");
        }
        if (!parent.getChildrenUnmodifiable().containsAll(nodes)) {
            throw new IllegalStateException("Not all nodes you've added with FXFocusManager.focusNodes(...), are children of your target container.");
        }
    }

    private static ObservableList<Node> getFocusNodes(Parent parent) {
        return (ObservableList)parent.getProperties().get((Object)IMPL_FOCUS_NODES_LIST_PROPERTY);
    }

    private static Parent getContainerBefore(Parent parent) {
        return (Parent)parent.getProperties().get((Object)IMPL_CONTAINER_BEFORE);
    }

    private static Parent getContainerAfter(Parent parent) {
        return (Parent)parent.getProperties().get((Object)IMPL_CONTAINER_AFTER);
    }
}

