/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.javafx.test.service;

import de.saxsys.javafx.test.service.ObservableGetter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.concurrent.Service;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;

public class ServiceWrapper
implements Worker {
    private final Service service;

    public ServiceWrapper(Service service) {
        this.service = service;
    }

    public void startAndWait(long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        this.callAndWaitService(timeout, () -> this.service.start());
    }

    public void restartAndWait(long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        this.callAndWaitService(timeout, () -> this.service.restart());
    }

    private void callAndWaitService(long timeout, Runnable serviceCall) throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture called = new CompletableFuture();
        ChangeListener listener = (observable, oldValue, newValue) -> {
            if (newValue == Worker.State.CANCELLED && oldValue == Worker.State.RUNNING || newValue == Worker.State.FAILED || newValue == Worker.State.SUCCEEDED) {
                called.complete(null);
            }
        };
        Platform.runLater(() -> {
            this.service.stateProperty().addListener(listener);
            serviceCall.run();
        });
        called.get(timeout, TimeUnit.MILLISECONDS);
        CompletableFuture removeListener = new CompletableFuture();
        Platform.runLater(() -> {
            this.service.stateProperty().removeListener(listener);
            removeListener.complete(null);
        });
        removeListener.get(1000L, TimeUnit.MILLISECONDS);
    }

    public void startAndWaitForValue(ObservableGetter observableGetter, Object targetValue, long timeoutInSeconds) throws InterruptedException, ExecutionException, TimeoutException {
        this.callService(observableGetter, targetValue, timeoutInSeconds, () -> this.service.start());
    }

    public void restartAndWaitForValue(ObservableGetter observableGetter, Object targetValue, long timeoutInSeconds) throws InterruptedException, ExecutionException, TimeoutException {
        this.callService(observableGetter, targetValue, timeoutInSeconds, () -> this.service.restart());
    }

    private void callService(ObservableGetter observableGetter, Object targetValue, long timeoutInSeconds, Runnable serviceCall) throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture future = new CompletableFuture();
        ChangeListener changeListener = (b, o, newValue) -> {
            if (newValue == targetValue) {
                future.complete(null);
            }
        };
        Platform.runLater(() -> {
            observableGetter.getValue().addListener(changeListener);
            serviceCall.run();
        });
        future.get(timeoutInSeconds, TimeUnit.SECONDS);
        CompletableFuture removedListenerFuture = new CompletableFuture();
        Platform.runLater(() -> {
            observableGetter.getValue().removeListener(changeListener);
            removedListenerFuture.complete(null);
        });
        removedListenerFuture.get(1L, TimeUnit.SECONDS);
    }

    private <T> T callMethodInUIThread(Supplier<T> call) {
        CompletableFuture called = new CompletableFuture();
        Platform.runLater(() -> {
            try {
                called.complete(call.get());
            }
            catch (Exception e) {
                called.completeExceptionally(e);
            }
        });
        try {
            return called.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public final Worker.State getState() {
        return this.callMethodInUIThread(() -> this.service.getState());
    }

    public final ReadOnlyObjectProperty stateProperty() {
        return this.service.stateProperty();
    }

    public final Object getValue() {
        return this.callMethodInUIThread(() -> this.service.getValue());
    }

    public final ReadOnlyObjectProperty valueProperty() {
        return this.callMethodInUIThread(() -> this.service.valueProperty());
    }

    public final Throwable getException() {
        return this.callMethodInUIThread(() -> this.service.getException());
    }

    public final ReadOnlyObjectProperty exceptionProperty() {
        return this.callMethodInUIThread(() -> this.service.exceptionProperty());
    }

    public final double getWorkDone() {
        return this.callMethodInUIThread(() -> this.service.getWorkDone());
    }

    public final ReadOnlyDoubleProperty workDoneProperty() {
        return this.callMethodInUIThread(() -> this.service.workDoneProperty());
    }

    public final double getTotalWork() {
        return this.callMethodInUIThread(() -> this.service.getTotalWork());
    }

    public final ReadOnlyDoubleProperty totalWorkProperty() {
        return this.callMethodInUIThread(() -> this.service.totalWorkProperty());
    }

    public final double getProgress() {
        return this.callMethodInUIThread(() -> this.service.getProgress());
    }

    public final ReadOnlyDoubleProperty progressProperty() {
        return this.callMethodInUIThread(() -> this.service.progressProperty());
    }

    public final boolean isRunning() {
        return this.callMethodInUIThread(() -> this.service.isRunning());
    }

    public final ReadOnlyBooleanProperty runningProperty() {
        return this.callMethodInUIThread(() -> this.service.runningProperty());
    }

    public final String getMessage() {
        return this.callMethodInUIThread(() -> this.service.getMessage());
    }

    public final ReadOnlyStringProperty messageProperty() {
        return this.callMethodInUIThread(() -> this.service.messageProperty());
    }

    public final String getTitle() {
        return this.callMethodInUIThread(() -> this.service.getTitle());
    }

    public final ReadOnlyStringProperty titleProperty() {
        return this.callMethodInUIThread(() -> this.service.titleProperty());
    }

    public final Executor getExecutor() {
        return this.callMethodInUIThread(() -> this.service.getExecutor());
    }

    public final ObjectProperty executorProperty() {
        return this.callMethodInUIThread(() -> this.service.executorProperty());
    }

    public final ObjectProperty onReadyProperty() {
        return this.callMethodInUIThread(() -> this.service.onReadyProperty());
    }

    public final EventHandler getOnReady() {
        return this.callMethodInUIThread(() -> this.service.getOnReady());
    }

    public final ObjectProperty onScheduledProperty() {
        return this.callMethodInUIThread(() -> this.service.onScheduledProperty());
    }

    public final EventHandler getOnScheduled() {
        return this.callMethodInUIThread(() -> this.service.getOnScheduled());
    }

    public final ObjectProperty onRunningProperty() {
        return this.callMethodInUIThread(() -> this.service.onRunningProperty());
    }

    public final EventHandler getOnRunning() {
        return this.callMethodInUIThread(() -> this.service.getOnRunning());
    }

    public final ObjectProperty onSucceededProperty() {
        return this.callMethodInUIThread(() -> this.service.onSucceededProperty());
    }

    public final EventHandler getOnSucceeded() {
        return this.callMethodInUIThread(() -> this.service.getOnSucceeded());
    }

    public final ObjectProperty onCancelledProperty() {
        return this.callMethodInUIThread(() -> this.service.onCancelledProperty());
    }

    public final EventHandler getOnCancelled() {
        return this.callMethodInUIThread(() -> this.service.getOnCancelled());
    }

    public final ObjectProperty onFailedProperty() {
        return this.callMethodInUIThread(() -> this.service.onFailedProperty());
    }

    public final EventHandler getOnFailed() {
        return this.callMethodInUIThread(() -> this.service.getOnFailed());
    }

    public boolean cancel() {
        return this.callMethodInUIThread(() -> this.service.cancel());
    }

    public void reset() {
        this.callMethodInUIThread(() -> {
            this.service.reset();
            return null;
        });
    }
}

