/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.testingutils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;

public class FxTestingUtils {
    public static void runInFXThread(Runnable code) {
        FxTestingUtils.runInFXThread(code, 1000L);
    }

    public static void runInFXThread(Runnable code, long timeout) {
        CompletableFuture future = new CompletableFuture();
        Platform.runLater(() -> {
            try {
                code.run();
            }
            catch (AssertionError e) {
                future.complete(e);
                return;
            }
            future.complete(null);
        });
        try {
            Object result = future.get(timeout + 50L, TimeUnit.MILLISECONDS);
            if (result instanceof AssertionError) {
                throw (AssertionError)result;
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    public static void waitForUiThread(long timeout) {
        FxTestingUtils.runInFXThread(() -> {}, timeout);
    }

    public static void waitForUiThread() {
        FxTestingUtils.waitForUiThread(1000L);
    }
}

