/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.zbdd;

import de.sayayi.lib.zbdd.ZbddCapacityAdvisor;
import de.sayayi.lib.zbdd.ZbddException;
import de.sayayi.lib.zbdd.ZbddLiteralResolver;
import de.sayayi.lib.zbdd.ZbddStatistics;
import de.sayayi.lib.zbdd.cache.ZbddCache;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class Zbdd
implements Cloneable {
    private static final int GC_VAR_MARK_MASK = Integer.MIN_VALUE;
    private static final int NODE_RECORD_SIZE = 6;
    public static final int MAX_NODES = 0x15555555;
    private static final int _VAR = 0;
    private static final int _P0 = 1;
    private static final int _P1 = 2;
    private static final int _NEXT = 3;
    private static final int _CHAIN = 4;
    private static final int _REFCOUNT = 5;
    protected static final int ZBDD_EMPTY = 0;
    protected static final int ZBDD_BASE = 1;
    @NotNull
    private final ZbddCapacityAdvisor capacityAdvisor;
    @NotNull
    private final Statistics statistics;
    private ZbddCache zbddCache = null;
    private int lastVarNumber;
    private int nodesCapacity;
    private int nodesFree;
    private int nodesDead;
    private int @NotNull [] nodes;
    private int nextFreeNode;
    @NotNull
    private ZbddLiteralResolver literalResolver = var -> "v" + var;

    public Zbdd() {
        this(DefaultCapacityAdvisor.INSTANCE);
    }

    public Zbdd(@NotNull ZbddCapacityAdvisor capacityAdvisor) {
        this.capacityAdvisor = capacityAdvisor;
        this.nodesCapacity = Math.max(capacityAdvisor.getInitialCapacity(), 8);
        this.nodes = new int[this.nodesCapacity * 6];
        this.initLeafNode(0);
        this.initLeafNode(1);
        this.statistics = new Statistics();
        this.clear();
    }

    protected Zbdd(@NotNull Zbdd zbdd) {
        this.capacityAdvisor = zbdd.capacityAdvisor;
        this.lastVarNumber = zbdd.lastVarNumber;
        this.nodesCapacity = zbdd.nodesCapacity;
        this.nodesFree = zbdd.nodesFree;
        this.nodesDead = zbdd.nodesDead;
        this.nodes = Arrays.copyOf(zbdd.nodes, zbdd.nodes.length);
        this.nextFreeNode = zbdd.nextFreeNode;
        this.literalResolver = zbdd.literalResolver;
        this.statistics = new Statistics();
    }

    private void initLeafNode(int zbdd) {
        int offset = zbdd * 6;
        this.nodes[offset + 0] = -1;
        this.nodes[offset + 1] = zbdd;
        this.nodes[offset + 2] = zbdd;
    }

    @Contract(mutates="this,param1")
    public void setZbddCache(ZbddCache zbddCache) {
        this.zbddCache = zbddCache;
        if (zbddCache != null) {
            zbddCache.clear();
        }
    }

    @Contract(pure=true)
    public ZbddCache getZbddCache() {
        return this.zbddCache;
    }

    @Contract(pure=true)
    public Zbdd clone() {
        return new Zbdd(this);
    }

    @Contract(pure=true)
    @NotNull
    public ZbddLiteralResolver getLiteralResolver() {
        return this.literalResolver;
    }

    @Contract(mutates="this")
    public void setLiteralResolver(@NotNull ZbddLiteralResolver literalResolver) {
        this.literalResolver = Objects.requireNonNull(literalResolver);
    }

    @Contract(pure=true)
    @NotNull
    public ZbddStatistics getStatistics() {
        return this.statistics;
    }

    @Contract(mutates="this")
    public void clear() {
        if (this.zbddCache != null) {
            this.zbddCache.clear();
        }
        this.lastVarNumber = 0;
        this.nodesDead = 0;
        this.nextFreeNode = 2;
        this.nodesFree = this.nodesCapacity - 2;
        for (int i = 2; i < this.nodesCapacity; ++i) {
            int offset = i * 6;
            this.nodes[offset + 0] = -1;
            this.nodes[offset + 3] = (i + 1) % this.nodesCapacity;
            this.nodes[offset + 4] = 0;
            this.nodes[offset + 5] = 0;
        }
        this.statistics.clear();
    }

    @Contract(pure=true)
    public static boolean isEmpty(@Range(from=0L, to=0x15555555L) int zbdd) {
        return zbdd == 0;
    }

    @Contract(pure=true)
    public static boolean isBase(@Range(from=0L, to=0x15555555L) int zbdd) {
        return zbdd == 1;
    }

    @Contract(mutates="this")
    public @Range(from=1L, to=0x7FFFFFFFL) int createVar() {
        return ++this.lastVarNumber;
    }

    @Contract(pure=true)
    public final int empty() {
        return 0;
    }

    @Contract(pure=true)
    public final int base() {
        return 1;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int cube(@Range(from=1L, to=0x7FFFFFFFL) int var) {
        return this.getNode(this.checkVar(var), 0, 1);
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int cube(int ... cubeVars) {
        int n = cubeVars.length;
        if (n == 0) {
            return this.base();
        }
        if (n == 1) {
            return this.cube(cubeVars[0]);
        }
        cubeVars = Arrays.copyOf(cubeVars, n);
        Arrays.sort(cubeVars);
        int r = 1;
        for (int var : cubeVars) {
            if (this.checkVar(var) == this.getVar(r)) continue;
            r = this.getNode(var, 0, r);
        }
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int subset0(@Range(from=0L, to=0x15555555L) int zbdd, @Range(from=1L, to=0x7FFFFFFFL) int var) {
        this.checkZbdd(zbdd, "zbdd");
        this.checkVar(var);
        return this.zbddCache != null ? this.__subset0_cache(zbdd, var) : this.__subset0(zbdd, var);
    }

    @Contract(mutates="this")
    protected int __subset0_cache(int zbdd, int var) {
        int top = this.getVar(zbdd);
        if (top < var) {
            return zbdd;
        }
        if (top == var) {
            return this.getP0(zbdd);
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation2.SUBSET0, zbdd, var);
        if (r == Integer.MIN_VALUE) {
            this.__incRef(zbdd);
            int p0 = this.__incRef(this.__subset0_cache(this.getP0(zbdd), var));
            int p1 = this.__subset0_cache(this.getP1(zbdd), var);
            r = this.getNode(top, this.__decRef(p0), p1);
            this.zbddCache.putResult(ZbddCache.Operation2.SUBSET0, zbdd, var, r);
            this.__decRef(zbdd);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __subset0(int zbdd, int var) {
        int top = this.getVar(zbdd);
        if (top < var) {
            return zbdd;
        }
        if (top == var) {
            return this.getP0(zbdd);
        }
        this.__incRef(zbdd);
        int p0 = this.__incRef(this.__subset0(this.getP0(zbdd), var));
        int p1 = this.__subset0(this.getP1(zbdd), var);
        int r = this.getNode(top, this.__decRef(p0), p1);
        this.__decRef(zbdd);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int subset1(@Range(from=0L, to=0x15555555L) int zbdd, @Range(from=1L, to=0x7FFFFFFFL) int var) {
        this.checkZbdd(zbdd, "zbdd");
        this.checkVar(var);
        return this.zbddCache != null ? this.__subset1_cache(zbdd, var) : this.__subset1(zbdd, var);
    }

    @Contract(mutates="this")
    protected int __subset1_cache(int zbdd, int var) {
        int top = this.getVar(zbdd);
        if (top < var) {
            return 0;
        }
        if (top == var) {
            return this.getP1(zbdd);
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation2.SUBSET1, zbdd, var);
        if (r == Integer.MIN_VALUE) {
            this.__incRef(zbdd);
            int p0 = this.__incRef(this.__subset1_cache(this.getP0(zbdd), var));
            int p1 = this.__subset1_cache(this.getP1(zbdd), var);
            r = this.getNode(top, this.__decRef(p0), p1);
            this.zbddCache.putResult(ZbddCache.Operation2.SUBSET1, zbdd, var, r);
            this.__decRef(zbdd);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __subset1(int zbdd, int var) {
        int top = this.getVar(zbdd);
        if (top < var) {
            return 0;
        }
        if (top == var) {
            return this.getP1(zbdd);
        }
        this.__incRef(zbdd);
        int p0 = this.__incRef(this.__subset1(this.getP0(zbdd), var));
        int p1 = this.__subset1(this.getP1(zbdd), var);
        int r = this.getNode(top, this.__decRef(p0), p1);
        this.__decRef(zbdd);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int change(@Range(from=0L, to=0x15555555L) int zbdd, @Range(from=1L, to=0x7FFFFFFFL) int var) {
        this.checkZbdd(zbdd, "zbdd");
        this.checkVar(var);
        return this.zbddCache != null ? this.__change_cache(zbdd, var) : this.__change(zbdd, var);
    }

    @Contract(mutates="this")
    protected int __change_cache(int zbdd, int var) {
        int top = this.getVar(zbdd);
        if (top < var) {
            return this.getNode(var, 0, zbdd);
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation2.CHANGE, zbdd, var);
        if (r == Integer.MIN_VALUE) {
            this.__incRef(zbdd);
            if (top == var) {
                r = this.getNode(var, this.getP1(zbdd), this.getP0(zbdd));
            } else {
                int p0 = this.__incRef(this.__change_cache(this.getP0(zbdd), var));
                int p1 = this.__change_cache(this.getP1(zbdd), var);
                r = this.getNode(top, this.__decRef(p0), p1);
            }
            this.zbddCache.putResult(ZbddCache.Operation2.CHANGE, zbdd, var, r);
            this.__decRef(zbdd);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __change(int zbdd, int var) {
        int r;
        int top = this.getVar(zbdd);
        if (top < var) {
            return this.getNode(var, 0, zbdd);
        }
        this.__incRef(zbdd);
        if (top == var) {
            r = this.getNode(var, this.getP1(zbdd), this.getP0(zbdd));
        } else {
            int p0 = this.__incRef(this.__change(this.getP0(zbdd), var));
            int p1 = this.__change(this.getP1(zbdd), var);
            r = this.getNode(top, this.__decRef(p0), p1);
        }
        this.__decRef(zbdd);
        return r;
    }

    @Contract(pure=true)
    public @Range(from=0L, to=0x7FFFFFFFL) int count(@Range(from=0L, to=0x15555555L) int zbdd) {
        this.checkZbdd(zbdd, "zbdd");
        return this.zbddCache != null ? this.__count_cache(zbdd) : this.__count(zbdd);
    }

    @Contract(pure=true)
    protected int __count_cache(int zbdd) {
        if (zbdd < 2) {
            return zbdd;
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation1.COUNT, zbdd);
        if (r == Integer.MIN_VALUE) {
            int offset = zbdd * 6;
            r = this.__count(this.nodes[offset + 1]) + this.__count(this.nodes[offset + 2]);
            this.zbddCache.putResult(ZbddCache.Operation1.COUNT, zbdd, r);
        }
        return r;
    }

    @Contract(pure=true)
    protected int __count(int zbdd) {
        if (zbdd < 2) {
            return zbdd;
        }
        int offset = zbdd * 6;
        return this.__count(this.nodes[offset + 1]) + this.__count(this.nodes[offset + 2]);
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int union(@Range(from=0L, to=0x15555555L) int p, @Range(from=0L, to=0x15555555L) int q) {
        this.checkZbdd(p, "p");
        this.checkZbdd(p, "q");
        return this.zbddCache != null ? this.__union_cache(p, q) : this.__union(p, q);
    }

    @Contract(mutates="this")
    protected int __union_cache(int p, int q) {
        int r;
        int qtop;
        if (q == 0 || p == q) {
            return p;
        }
        if (p == 0) {
            return q;
        }
        int ptop = this.getVar(p);
        if (ptop > (qtop = this.getVar(q))) {
            int tmp = p;
            p = q;
            q = tmp;
            tmp = ptop;
            ptop = qtop;
            qtop = tmp;
        }
        if ((r = this.zbddCache.getResult(ZbddCache.Operation2.UNION, p, q)) == Integer.MIN_VALUE) {
            this.__incRef(p);
            this.__incRef(q);
            if (ptop < qtop) {
                r = this.getNode(qtop, this.__union_cache(p, this.getP0(q)), this.getP1(q));
            } else {
                int p0 = this.__incRef(this.__union_cache(this.getP0(p), this.getP0(q)));
                int p1 = this.__union_cache(this.getP1(p), this.getP1(q));
                r = this.getNode(ptop, this.__decRef(p0), p1);
            }
            this.zbddCache.putResult(ZbddCache.Operation2.UNION, p, q, r);
            this.__decRef(q);
            this.__decRef(p);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __union(int p, int q) {
        int r;
        int qtop;
        if (q == 0 || p == q) {
            return p;
        }
        if (p == 0) {
            return q;
        }
        int ptop = this.getVar(p);
        if (ptop > (qtop = this.getVar(q))) {
            int tmp = p;
            p = q;
            q = tmp;
            tmp = ptop;
            ptop = qtop;
            qtop = tmp;
        }
        this.__incRef(p);
        this.__incRef(q);
        if (ptop < qtop) {
            r = this.getNode(qtop, this.__union(p, this.getP0(q)), this.getP1(q));
        } else {
            int p0 = this.__incRef(this.__union(this.getP0(p), this.getP0(q)));
            int p1 = this.__union(this.getP1(p), this.getP1(q));
            r = this.getNode(ptop, this.__decRef(p0), p1);
        }
        this.__decRef(q);
        this.__decRef(p);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int intersect(@Range(from=0L, to=0x15555555L) int p, @Range(from=0L, to=0x15555555L) int q) {
        this.checkZbdd(p, "p");
        this.checkZbdd(p, "q");
        return this.zbddCache != null ? this.__intersect_cache(p, q) : this.__intersect(p, q);
    }

    @Contract(mutates="this")
    protected int __intersect_cache(int p, int q) {
        if (p == 0 || q == 0) {
            return 0;
        }
        if (p == q) {
            return p;
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation2.INTERSECT, p, q);
        if (r == Integer.MIN_VALUE) {
            int ptop = this.getVar(p);
            int qtop = this.getVar(q);
            this.__incRef(p);
            this.__incRef(q);
            if (ptop > qtop) {
                r = this.__intersect_cache(this.getP0(p), q);
            } else if (ptop < qtop) {
                r = this.__intersect_cache(p, this.getP0(q));
            } else {
                int p0 = this.__incRef(this.__intersect_cache(this.getP0(p), this.getP0(q)));
                int p1 = this.__intersect_cache(this.getP1(p), this.getP1(q));
                r = this.getNode(ptop, this.__decRef(p0), p1);
            }
            this.zbddCache.putResult(ZbddCache.Operation2.INTERSECT, p, q, r);
            this.__decRef(q);
            this.__decRef(p);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __intersect(int p, int q) {
        int r;
        if (p == 0 || q == 0) {
            return 0;
        }
        if (p == q) {
            return p;
        }
        int ptop = this.getVar(p);
        int qtop = this.getVar(q);
        this.__incRef(p);
        this.__incRef(q);
        if (ptop > qtop) {
            r = this.__intersect(this.getP0(p), q);
        } else if (ptop < qtop) {
            r = this.__intersect(p, this.getP0(q));
        } else {
            int p0 = this.__incRef(this.__intersect(this.getP0(p), this.getP0(q)));
            int p1 = this.__intersect(this.getP1(p), this.getP1(q));
            r = this.getNode(ptop, this.__decRef(p0), p1);
        }
        this.__decRef(q);
        this.__decRef(p);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int difference(@Range(from=0L, to=0x15555555L) int p, @Range(from=0L, to=0x15555555L) int q) {
        this.checkZbdd(p, "p");
        this.checkZbdd(p, "q");
        return this.zbddCache != null ? this.__difference_cache(p, q) : this.__difference(p, q);
    }

    @Contract(mutates="this")
    protected int __difference_cache(int p, int q) {
        if (p == 0 || p == q) {
            return 0;
        }
        if (q == 0) {
            return p;
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation2.DIFFERENCE, p, q);
        if (r == Integer.MIN_VALUE) {
            int ptop = this.getVar(p);
            int qtop = this.getVar(q);
            this.__incRef(p);
            this.__incRef(q);
            if (ptop < qtop) {
                r = this.__difference_cache(p, this.getP0(q));
            } else if (ptop > qtop) {
                r = this.getNode(ptop, this.__difference_cache(this.getP0(p), this.getP0(q)), this.getP1(p));
            } else {
                int p0 = this.__incRef(this.__difference_cache(this.getP0(p), this.getP0(q)));
                int p1 = this.__difference_cache(this.getP1(p), this.getP1(q));
                r = this.getNode(ptop, this.__decRef(p0), p1);
            }
            this.zbddCache.putResult(ZbddCache.Operation2.DIFFERENCE, p, q, r);
            this.__decRef(q);
            this.__decRef(p);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __difference(int p, int q) {
        int r;
        if (p == 0 || p == q) {
            return 0;
        }
        if (q == 0) {
            return p;
        }
        int ptop = this.getVar(p);
        int qtop = this.getVar(q);
        this.__incRef(p);
        this.__incRef(q);
        if (ptop < qtop) {
            r = this.__difference(p, this.getP0(q));
        } else if (ptop > qtop) {
            r = this.getNode(ptop, this.__difference(this.getP0(p), this.getP0(q)), this.getP1(p));
        } else {
            int p0 = this.__incRef(this.__difference(this.getP0(p), this.getP0(q)));
            int p1 = this.__difference(this.getP1(p), this.getP1(q));
            r = this.getNode(ptop, this.__decRef(p0), p1);
        }
        this.__decRef(q);
        this.__decRef(p);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int multiply(@Range(from=0L, to=0x15555555L) int p, @Range(from=0L, to=0x15555555L) int q) {
        this.checkZbdd(p, "p");
        this.checkZbdd(p, "q");
        return this.zbddCache != null ? this.__multiply_cache(p, q) : this.__multiply(p, q);
    }

    @Contract(mutates="this")
    protected int __multiply_cache(int p, int q) {
        int qtop;
        if (p == 0 || q == 0) {
            return 0;
        }
        if (p == 1) {
            return q;
        }
        if (q == 1) {
            return p;
        }
        int ptop = this.getVar(p);
        if (ptop > (qtop = this.getVar(q))) {
            return this.__multiply_cache(q, p);
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation2.MULTIPLY, p, q);
        if (r == Integer.MIN_VALUE) {
            this.__incRef(p);
            this.__incRef(q);
            int p0 = this.__incRef(this.__subset0_cache(p, ptop));
            int p1 = this.__incRef(this.__subset1_cache(p, ptop));
            int q0 = this.__incRef(this.__subset0_cache(q, ptop));
            int q1 = this.__incRef(this.__subset1_cache(q, ptop));
            int p0q0 = this.__incRef(this.__multiply_cache(p0, q0));
            int p0q1 = this.__incRef(this.__multiply_cache(p0, q1));
            int p1q0 = this.__incRef(this.__multiply_cache(p1, q0));
            int p1q1 = this.__incRef(this.__multiply_cache(p1, q1));
            r = this.__union_cache(p0q0, this.__change_cache(this.__union_cache(this.__union_cache(p0q1, p1q0), p1q1), ptop));
            this.zbddCache.putResult(ZbddCache.Operation2.MULTIPLY, p, q, r);
            this.__decRef(p1q1);
            this.__decRef(p1q0);
            this.__decRef(p0q1);
            this.__decRef(p0q0);
            this.__decRef(q1);
            this.__decRef(q0);
            this.__decRef(p1);
            this.__decRef(p0);
            this.__decRef(q);
            this.__decRef(p);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __multiply(int p, int q) {
        int qtop;
        if (p == 0 || q == 0) {
            return 0;
        }
        if (p == 1) {
            return q;
        }
        if (q == 1) {
            return p;
        }
        int ptop = this.getVar(p);
        if (ptop > (qtop = this.getVar(q))) {
            return this.__multiply(q, p);
        }
        this.__incRef(p);
        this.__incRef(q);
        int p0 = this.__incRef(this.__subset0(p, ptop));
        int p1 = this.__incRef(this.__subset1(p, ptop));
        int q0 = this.__incRef(this.__subset0(q, ptop));
        int q1 = this.__incRef(this.__subset1(q, ptop));
        int p0q0 = this.__incRef(this.__multiply(p0, q0));
        int p0q1 = this.__incRef(this.__multiply(p0, q1));
        int p1q0 = this.__incRef(this.__multiply(p1, q0));
        int p1q1 = this.__incRef(this.__multiply(p1, q1));
        int r = this.__union(p0q0, this.__change(this.__union(this.__union(p0q1, p1q0), p1q1), ptop));
        this.__decRef(p1q1);
        this.__decRef(p1q0);
        this.__decRef(p0q1);
        this.__decRef(p0q0);
        this.__decRef(q1);
        this.__decRef(q0);
        this.__decRef(p1);
        this.__decRef(p0);
        this.__decRef(q);
        this.__decRef(p);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int divide(@Range(from=0L, to=0x15555555L) int p, @Range(from=0L, to=0x15555555L) int q) {
        this.checkZbdd(p, "p");
        this.checkZbdd(p, "q");
        return this.zbddCache != null ? this.__divide_cache(p, q) : this.__divide(p, q);
    }

    @Contract(mutates="this")
    protected int __divide_cache(int p, int q) {
        if (p < 2) {
            return 0;
        }
        if (p == q) {
            return 1;
        }
        if (q == 1) {
            return p;
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation2.DIVIDE, p, q);
        if (r == Integer.MIN_VALUE) {
            this.__incRef(p);
            this.__incRef(q);
            int v = this.getVar(q);
            int p0 = this.__incRef(this.__subset0_cache(p, v));
            int p1 = this.__incRef(this.__subset1_cache(p, v));
            int q0 = this.__incRef(this.__subset0_cache(q, v));
            int q1 = this.__subset1_cache(q, v);
            int r1 = this.__divide_cache(this.__decRef(p1), q1);
            if (r1 != 0 && q0 != 0) {
                this.__incRef(r1);
                int r0 = this.__divide_cache(p0, q0);
                r = this.__intersect_cache(this.__decRef(r1), r0);
            } else {
                r = r1;
            }
            this.zbddCache.putResult(ZbddCache.Operation2.DIVIDE, p, q, r);
            this.__decRef(q0);
            this.__decRef(p0);
            this.__decRef(q);
            this.__decRef(p);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __divide(int p, int q) {
        int r;
        if (p < 2) {
            return 0;
        }
        if (p == q) {
            return 1;
        }
        if (q == 1) {
            return p;
        }
        this.__incRef(p);
        this.__incRef(q);
        int v = this.getVar(q);
        int p0 = this.__incRef(this.__subset0(p, v));
        int p1 = this.__incRef(this.__subset1(p, v));
        int q0 = this.__incRef(this.__subset0(q, v));
        int q1 = this.__subset1(q, v);
        int r1 = this.__divide(this.__decRef(p1), q1);
        if (r1 != 0 && q0 != 0) {
            this.__incRef(r1);
            int r0 = this.__divide(p0, q0);
            r = this.__intersect(this.__decRef(r1), r0);
        } else {
            r = r1;
        }
        this.__decRef(q0);
        this.__decRef(p0);
        this.__decRef(q);
        this.__decRef(p);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int modulo(@Range(from=0L, to=0x15555555L) int p, @Range(from=0L, to=0x15555555L) int q) {
        this.checkZbdd(p, "p");
        this.checkZbdd(p, "q");
        return this.zbddCache != null ? this.__modulo_cache(p, q) : this.__modulo(p, q);
    }

    @Contract(mutates="this")
    protected int __modulo_cache(int p, int q) {
        int r = this.zbddCache.getResult(ZbddCache.Operation2.MODULO, p, q);
        if (r == Integer.MIN_VALUE) {
            this.__incRef(p);
            this.__incRef(q);
            r = this.__difference_cache(p, this.__multiply_cache(q, this.__divide_cache(p, q)));
            this.zbddCache.putResult(ZbddCache.Operation2.MODULO, p, q, r);
            this.__decRef(q);
            this.__decRef(p);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __modulo(int p, int q) {
        this.__incRef(p);
        this.__incRef(q);
        int r = this.__difference(p, this.__multiply(q, this.__divide(p, q)));
        this.__decRef(q);
        this.__decRef(p);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int atomize(@Range(from=0L, to=0x15555555L) int zbdd) {
        this.checkZbdd(zbdd, "zbdd");
        return this.zbddCache != null ? this.__atomize_cache(zbdd) : this.__atomize(zbdd);
    }

    @Contract(mutates="this")
    protected int __atomize_cache(int zbdd) {
        if (zbdd < 2) {
            return 0;
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation1.ATOMIZE, zbdd);
        if (r == Integer.MIN_VALUE) {
            this.__incRef(zbdd);
            int p0 = this.__incRef(this.__atomize_cache(this.getP0(zbdd)));
            int p1 = this.__atomize_cache(this.getP1(zbdd));
            r = this.getNode(this.getVar(zbdd), this.__union_cache(this.__decRef(p0), p1), 1);
            this.zbddCache.putResult(ZbddCache.Operation1.ATOMIZE, zbdd, r);
            this.__decRef(zbdd);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __atomize(int zbdd) {
        if (zbdd < 2) {
            return 0;
        }
        this.__incRef(zbdd);
        int p0 = this.__incRef(this.__atomize(this.getP0(zbdd)));
        int p1 = this.__atomize(this.getP1(zbdd));
        int r = this.getNode(this.getVar(zbdd), this.__union(this.__decRef(p0), p1), 1);
        this.__decRef(zbdd);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) int removeBase(@Range(from=0L, to=0x15555555L) int zbdd) {
        this.checkZbdd(zbdd, "zbdd");
        return this.zbddCache != null ? this.__removeBase_cache(zbdd) : this.__removeBase(zbdd);
    }

    @Contract(mutates="this")
    protected int __removeBase_cache(int zbdd) {
        if (zbdd < 2) {
            return 0;
        }
        int r = this.zbddCache.getResult(ZbddCache.Operation1.REMOVE_BASE, zbdd);
        if (r == Integer.MIN_VALUE) {
            this.__incRef(zbdd);
            r = this.getNode(this.getVar(zbdd), this.__removeBase_cache(this.getP0(zbdd)), this.getP1(zbdd));
            this.zbddCache.putResult(ZbddCache.Operation1.REMOVE_BASE, zbdd, r);
            this.__decRef(zbdd);
        }
        return r;
    }

    @Contract(mutates="this")
    protected int __removeBase(int zbdd) {
        if (zbdd < 2) {
            return 0;
        }
        this.__incRef(zbdd);
        int r = this.getNode(this.getVar(zbdd), this.__removeBase(this.getP0(zbdd)), this.getP1(zbdd));
        this.__decRef(zbdd);
        return r;
    }

    @Contract(mutates="this")
    public @Range(from=0L, to=0x15555555L) boolean contains(@Range(from=0L, to=0x15555555L) int p, @Range(from=0L, to=0x15555555L) int q) {
        return this.__contains(this.checkZbdd(p, "p"), this.checkZbdd(q, "q"));
    }

    @Contract(mutates="this")
    protected boolean __contains(int p, int q) {
        return p != 0 && q != 0 && (p == q || (this.zbddCache != null ? this.__intersect_cache(p, q) : this.__intersect(p, q)) == q);
    }

    @Contract(mutates="this")
    protected @Range(from=0L, to=0x15555555L) int getNode(@Range(from=1L, to=0x7FFFFFFFL) int var, @Range(from=0L, to=0x15555555L) int p0, @Range(from=0L, to=0x15555555L) int p1) {
        int offset;
        this.statistics.nodeLookups++;
        if (p1 == 0) {
            this.statistics.nodeLookupHitCount++;
            return p0;
        }
        int hash = this.hash(var, p0, p1);
        int r = this.nodes[hash * 6 + 4];
        while (r != 0) {
            offset = r * 6;
            if (this.nodes[offset + 0] == var && this.nodes[offset + 1] == p0 && this.nodes[offset + 2] == p1) {
                this.statistics.nodeLookupHitCount++;
                return r;
            }
            r = this.nodes[offset + 3];
        }
        if (this.nodesFree < 2) {
            this.__incRef(p0);
            this.__incRef(p1);
            this.ensureCapacity();
            this.__decRef(p1);
            this.__decRef(p0);
            if (this.nodesFree == 0) {
                throw new ZbddException("nodes capacity exhausted");
            }
            hash = this.hash(var, p0, p1);
        }
        r = this.nextFreeNode;
        offset = r * 6;
        this.nextFreeNode = this.nodes[offset + 3];
        --this.nodesFree;
        this.nodes[offset + 0] = var;
        this.nodes[offset + 1] = p0;
        this.nodes[offset + 2] = p1;
        this.nodes[offset + 5] = -1;
        this.prependHashChain(r, hash);
        return r;
    }

    @Contract(pure=true)
    protected int getVar(int zbdd) {
        return zbdd < 2 ? -1 : this.nodes[zbdd * 6 + 0];
    }

    @Contract(pure=true)
    protected @Range(from=0L, to=0x15555555L) int getP0(int zbdd) {
        return this.nodes[zbdd * 6 + 1];
    }

    @Contract(pure=true)
    protected @Range(from=0L, to=0x15555555L) int getP1(int zbdd) {
        return this.nodes[zbdd * 6 + 2];
    }

    @Contract(pure=true)
    protected @Range(from=0L, to=0x15555555L) int hash(int var, int p0, int p1) {
        return (var * 0xC00005 + p0 * 4256249 + p1 * 741457 & Integer.MAX_VALUE) % this.nodesCapacity;
    }

    public @Range(from=0L, to=0x15555553L) int gc() {
        if (this.zbddCache != null) {
            this.zbddCache.clear();
        }
        this.statistics.gcCount++;
        int i = this.nodesCapacity;
        while (i-- > 0) {
            int offset = i * 6;
            if (this.nodes[offset + 0] != -1 && this.nodes[offset + 5] > 0) {
                this.gc_markTree(i);
            }
            this.nodes[offset + 4] = 0;
        }
        int oldNodesFree = this.nodesFree;
        this.nodesFree = 0;
        this.nextFreeNode = 0;
        int i2 = this.nodesCapacity;
        while (i2-- > 2) {
            int offset = i2 * 6;
            if ((this.nodes[offset + 0] & Integer.MIN_VALUE) != 0 && this.nodes[offset + 0] != -1) {
                int n = offset + 0;
                int n2 = this.nodes[n] & Integer.MAX_VALUE;
                this.nodes[n] = n2;
                this.prependHashChain(i2, this.hash(n2, this.nodes[offset + 1], this.nodes[offset + 2]));
                continue;
            }
            this.nodes[offset + 0] = -1;
            this.nodes[offset + 3] = this.nextFreeNode;
            this.nodes[offset + 5] = 0;
            this.nextFreeNode = i2;
            ++this.nodesFree;
        }
        this.nodesDead = 0;
        int gcFreedNodesCount = this.nodesFree - oldNodesFree;
        Statistics statistics = this.statistics;
        statistics.gcFreedNodes = statistics.gcFreedNodes + (long)gcFreedNodesCount;
        return gcFreedNodesCount;
    }

    private void gc_markTree(int zbdd) {
        int offset;
        if (zbdd >= 2 && (this.nodes[(offset = zbdd * 6) + 0] & Integer.MIN_VALUE) == 0) {
            int n = offset + 0;
            this.nodes[n] = this.nodes[n] | Integer.MIN_VALUE;
            this.gc_markTree(this.nodes[offset + 1]);
            this.gc_markTree(this.nodes[offset + 2]);
        }
    }

    @Contract(mutates="this")
    protected void ensureCapacity() {
        int offset;
        if (this.nodesDead > 0 && this.capacityAdvisor.isGCRequired(this.statistics)) {
            this.gc();
            if (this.nodesFree >= this.capacityAdvisor.getMinimumFreeNodes(this.statistics)) {
                return;
            }
        }
        int oldNodesCapacity = this.nodesCapacity;
        this.nodesCapacity = Math.min(this.nodesCapacity + this.capacityAdvisor.adviseIncrement(this.statistics), 0x15555555);
        this.nodes = Arrays.copyOf(this.nodes, this.nodesCapacity * 6);
        this.nextFreeNode = 0;
        this.nodesFree = 0;
        int i = this.nodesCapacity;
        while (i-- > oldNodesCapacity) {
            offset = i * 6;
            this.nodes[offset + 0] = -1;
            this.nodes[offset + 3] = this.nextFreeNode;
            this.nextFreeNode = i;
            ++this.nodesFree;
        }
        int end = oldNodesCapacity * 6;
        for (i = 0; i < end; i += 6) {
            this.nodes[i + 4] = 0;
        }
        i = oldNodesCapacity;
        while (i-- > 2) {
            offset = i * 6;
            if (this.nodes[offset + 0] != -1) {
                this.prependHashChain(i, this.hash(this.nodes[offset + 0], this.nodes[offset + 1], this.nodes[offset + 2]));
                continue;
            }
            this.nodes[offset + 3] = this.nextFreeNode;
            this.nodes[offset + 5] = 0;
            this.nextFreeNode = i;
            ++this.nodesFree;
        }
    }

    private void prependHashChain(int zbdd, int hash) {
        int hashChain = hash * 6 + 4;
        this.nodes[zbdd * 6 + 3] = this.nodes[hashChain];
        this.nodes[hashChain] = zbdd;
    }

    @Contract(value="_ -> param1", mutates="this")
    public int incRef(@Range(from=0L, to=0x15555555L) int zbdd) {
        return this.__incRef(this.checkZbdd(zbdd, "zbdd"));
    }

    @Contract(value="_ -> param1", mutates="this")
    protected int __incRef(int zbdd) {
        int offset;
        if (zbdd >= 2 && this.nodes[(offset = zbdd * 6) + 0] != -1) {
            int refCountOffset = offset + 5;
            int ref = this.nodes[refCountOffset];
            if (ref == -1) {
                this.nodes[refCountOffset] = 1;
            } else {
                if (ref == 0) {
                    --this.nodesDead;
                }
                int n = refCountOffset;
                this.nodes[n] = this.nodes[n] + 1;
            }
        }
        return zbdd;
    }

    @Contract(value="_ -> param1", mutates="this")
    public int decRef(@Range(from=0L, to=0x15555555L) int zbdd) {
        return this.__decRef(this.checkZbdd(zbdd, "zbdd"));
    }

    @Contract(value="_ -> param1", mutates="this")
    protected int __decRef(int zbdd) {
        int refCountOffset;
        int ref;
        int offset;
        if (zbdd >= 2 && this.nodes[(offset = zbdd * 6) + 0] != -1 && (ref = this.nodes[refCountOffset = offset + 5]) > 0) {
            if (ref == 1) {
                ++this.nodesDead;
            }
            int n = refCountOffset;
            this.nodes[n] = this.nodes[n] - 1;
        }
        return zbdd;
    }

    @Contract(value="_, _ -> param1")
    @MustBeInvokedByOverriders
    protected int checkZbdd(int zbdd, @NotNull String param) {
        if (zbdd < 0 || zbdd >= this.nodesCapacity) {
            throw new ZbddException(param + " must be in range 0.." + (this.nodesCapacity - 1));
        }
        if (zbdd >= 2 && this.nodes[zbdd * 6 + 0] == -1) {
            throw new ZbddException("invalid " + param + " node " + zbdd);
        }
        return zbdd;
    }

    @Contract(value="_ -> param1")
    @MustBeInvokedByOverriders
    protected int checkVar(int var) {
        if (var <= 0 || var > this.lastVarNumber) {
            throw new ZbddException("var must be in range 1.." + var);
        }
        return var;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public String toString(@Range(from=0L, to=0x15555555L) int zbdd) {
        StringJoiner s = new StringJoiner(", ", "{ ", " }");
        this.visitCubes(zbdd, cube -> s.add(this.literalResolver.getCubeName(cube)));
        return s.toString();
    }

    public void visitCubes(@Range(from=0L, to=0x15555555L) int zbdd, @NotNull CubeVisitor visitor) {
        this.__incRef(zbdd);
        try {
            this.visitCubes0(visitor, new CubeVisitorStack(this.lastVarNumber), zbdd);
        }
        finally {
            this.__decRef(zbdd);
        }
    }

    @Contract(mutates="param2")
    private void visitCubes0(@NotNull CubeVisitor visitor, @NotNull CubeVisitorStack vars, int zbdd) {
        if (zbdd == 1) {
            visitor.visitCube(vars.getCube());
        } else if (zbdd != 0) {
            int offset = zbdd * 6;
            vars.push(this.nodes[offset + 0]);
            this.visitCubes0(visitor, vars, this.nodes[offset + 2]);
            vars.pop();
            this.visitCubes0(visitor, vars, this.nodes[offset + 1]);
        }
    }

    private static enum DefaultCapacityAdvisor implements ZbddCapacityAdvisor
    {
        INSTANCE;


        @Override
        public @Range(from=4L, to=0x15555555L) int getInitialCapacity() {
            return 128;
        }

        @Override
        public @Range(from=1L, to=0x15555555L) int getMinimumFreeNodes(@NotNull ZbddStatistics statistics) {
            return statistics.getNodesCapacity() / 20;
        }

        @Override
        public int adviseIncrement(@NotNull ZbddStatistics statistics) {
            int capacity = statistics.getNodesCapacity();
            return capacity < 500000 ? capacity * 3 / 2 : capacity / 10 * 3;
        }

        @Override
        public boolean isGCRequired(@NotNull ZbddStatistics statistics) {
            int capacity = statistics.getNodesCapacity();
            return capacity > 250000 || statistics.getDeadNodes() > capacity / 10;
        }
    }

    private final class Statistics
    implements ZbddStatistics {
        private int nodeLookups;
        private int nodeLookupHitCount;
        private int gcCount;
        private long gcFreedNodes;

        private Statistics() {
        }

        private void clear() {
            this.nodeLookups = 0;
            this.nodeLookupHitCount = 0;
            this.gcCount = 0;
            this.gcFreedNodes = 0L;
        }

        @Override
        public int getNodesCapacity() {
            return Zbdd.this.nodesCapacity;
        }

        @Override
        public int getFreeNodes() {
            return Zbdd.this.nodesFree;
        }

        @Override
        public int getDeadNodes() {
            return Zbdd.this.nodesDead;
        }

        @Override
        public int getNodeLookups() {
            return this.nodeLookups;
        }

        @Override
        public int getNodeLookupHitCount() {
            return this.nodeLookupHitCount;
        }

        @Override
        public int getGCCount() {
            return this.gcCount;
        }

        @Override
        public long getGCFreedNodes() {
            return this.gcFreedNodes;
        }

        @Override
        public long getMemoryUsage() {
            return (long)Zbdd.this.nodes.length * 4L;
        }

        @Override
        public int getRegisteredVars() {
            return Zbdd.this.lastVarNumber;
        }

        public String toString() {
            return "Statistics(node={capacity=" + this.getNodesCapacity() + ", occupied=" + this.getOccupiedNodes() + ", free=" + this.getFreeNodes() + ", dead=" + this.getDeadNodes() + "}, hitRatio=" + (double)Math.round(this.getNodeLookupHitRatio() * 1000.0) / 10.0 + "%, gcCount=" + this.getGCCount() + ", mem=" + String.format(Locale.ROOT, "%.1fKB", (double)this.getMemoryUsage() / 1024.0) + ")";
        }
    }

    private static final class CubeVisitorStack {
        private final int[] stack;
        private int stackSize;

        private CubeVisitorStack(int size) {
            this.stack = new int[size];
        }

        private void push(int value) {
            this.stack[this.stackSize++] = value;
        }

        private void pop() {
            if (this.stackSize > 0) {
                --this.stackSize;
            }
        }

        private int @NotNull [] getCube() {
            return Arrays.copyOf(this.stack, this.stackSize);
        }
    }

    public static interface CubeVisitor {
        public void visitCube(int @NotNull [] var1);
    }
}

