/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.zbdd;

import org.jetbrains.annotations.Contract;

public interface ZbddStatistics {
    @Contract(pure=true)
    public int getNodesCapacity();

    @Contract(pure=true)
    public int getFreeNodes();

    @Contract(pure=true)
    public int getDeadNodes();

    @Contract(pure=true)
    default public int getAvailableNodes() {
        return this.getFreeNodes() + this.getDeadNodes();
    }

    @Contract(pure=true)
    default public int getOccupiedNodes() {
        return this.getNodesCapacity() - this.getAvailableNodes();
    }

    @Contract(pure=true)
    public int getNodeLookups();

    @Contract(pure=true)
    public int getNodeLookupHitCount();

    @Contract(pure=true)
    default public double getNodeLookupHitRatio() {
        return (double)this.getNodeLookupHitCount() / (double)this.getNodeLookups();
    }

    @Contract(pure=true)
    default public double getNodeLookupMissRatio() {
        return 1.0 - this.getNodeLookupHitRatio();
    }

    @Contract(pure=true)
    public int getGCCount();

    @Contract(pure=true)
    public long getGCFreedNodes();

    @Contract(pure=true)
    public long getMemoryUsage();

    @Contract(pure=true)
    public int getRegisteredVars();
}

