/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.zbdd.cache;

import de.sayayi.lib.zbdd.cache.ZbddCache;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ZbddFastCache
implements ZbddCache {
    public static final int MIN_CACHE_SIZE = 1024;
    private static final int CHAIN_CAPACITY = 8;
    private static final int SLOT_ENTRY_SIZE1 = 3;
    private static final int SLOT_ENTRY_SIZE2 = 4;
    private static final int SLOT_CHAIN_SIZE1 = 24;
    private static final int SLOT_CHAIN_SIZE2 = 32;
    private final int slots;
    private final int capacity;
    private final int[] cache1;
    private int lookup1Count;
    private int cacheElementCount1;
    private final int[] cache2;
    private int lookup2Count;
    private int cacheElementCount2;
    private int lookupHitCount;

    public ZbddFastCache() {
        this(1024);
    }

    public ZbddFastCache(int size) {
        this.slots = Math.max(size, 1024) / 56;
        this.capacity = 2 * this.slots * 8;
        this.cache1 = new int[this.slots * 24];
        this.cache2 = new int[this.slots * 32];
    }

    @Override
    public void clear() {
        int n;
        int l = this.cache1.length;
        for (n = 0; n < l; n += 3) {
            this.cache1[n] = 0;
        }
        l = this.cache2.length;
        for (n = 0; n < l; n += 4) {
            this.cache2[n] = 0;
        }
        this.cacheElementCount2 = 0;
        this.cacheElementCount1 = 0;
    }

    @Override
    public int getResult(@NotNull ZbddCache.Operation1 operation, int p) {
        int op;
        ++this.lookup1Count;
        int slotIndex = this.hash1(operation, p) * 24;
        int operationNumber = operation.ordinal() + 1;
        int i = slotIndex;
        for (int n = 0; n < 8 && (op = this.cache1[i]) != 0; ++n) {
            if (operationNumber == op && this.cache1[i + 1] == p) {
                if (n >= 4) {
                    int[] tmp = new int[3];
                    System.arraycopy(this.cache1, i, tmp, 0, 3);
                    System.arraycopy(this.cache1, slotIndex, this.cache1, slotIndex + 3, n * 3);
                    System.arraycopy(tmp, 0, this.cache1, slotIndex, 3);
                    i = slotIndex;
                }
                ++this.lookupHitCount;
                return this.cache1[i + 2];
            }
            i += 3;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void putResult(@NotNull ZbddCache.Operation1 operation, int p, int result) {
        int op;
        int n;
        int slotIndex = this.hash1(operation, p) * 24;
        int operationNumber = operation.ordinal() + 1;
        int i = slotIndex;
        for (n = 0; n < 8 && (op = this.cache1[i]) != 0; ++n) {
            if (operationNumber == op && this.cache1[i + 1] == p) {
                return;
            }
            i += 3;
        }
        if (n > 0) {
            System.arraycopy(this.cache1, slotIndex, this.cache1, slotIndex + 3, Math.min(n, 7) * 3);
        }
        this.cache1[slotIndex] = operationNumber;
        this.cache1[slotIndex + 1] = p;
        this.cache1[slotIndex + 2] = result;
        if (n < 8) {
            ++this.cacheElementCount1;
        }
    }

    @Override
    public int getResult(@NotNull ZbddCache.Operation2 operation, int p1, int p2) {
        int op;
        ++this.lookup2Count;
        int slotIndex = this.hash2(operation, p1, p2) * 32;
        int operationNumber = operation.ordinal() + 1;
        int i = slotIndex;
        for (int n = 0; n < 8 && (op = this.cache2[i]) != 0; ++n) {
            if (operationNumber == op && this.cache2[i + 1] == p1 && this.cache2[i + 2] == p2) {
                if (n >= 4) {
                    int[] tmp = new int[4];
                    System.arraycopy(this.cache2, i, tmp, 0, 4);
                    System.arraycopy(this.cache2, slotIndex, this.cache2, slotIndex + 4, n * 4);
                    System.arraycopy(tmp, 0, this.cache2, slotIndex, 4);
                    i = slotIndex;
                }
                ++this.lookupHitCount;
                return this.cache2[i + 3];
            }
            i += 4;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void putResult(@NotNull ZbddCache.Operation2 operation, int p1, int p2, int result) {
        int op;
        int n;
        int slotIndex = this.hash2(operation, p1, p2) * 32;
        int operationNumber = operation.ordinal() + 1;
        int i = slotIndex;
        for (n = 0; n < 8 && (op = this.cache2[i]) != 0; ++n) {
            if (operationNumber == op && this.cache2[i + 1] == p1 && this.cache2[i + 2] == p2) {
                return;
            }
            i += 4;
        }
        if (n > 0) {
            System.arraycopy(this.cache2, slotIndex, this.cache2, slotIndex + 4, Math.min(n, 7) * 4);
        }
        this.cache2[slotIndex] = operationNumber;
        this.cache2[slotIndex + 1] = p1;
        this.cache2[slotIndex + 2] = p2;
        this.cache2[slotIndex + 3] = result;
        if (n < 8) {
            ++this.cacheElementCount2;
        }
    }

    @Contract(pure=true)
    private int hash1(@NotNull ZbddCache.Operation1 operation, int p) {
        return (operation.ordinal() * 4256249 + p * 741457 & Integer.MAX_VALUE) % this.slots;
    }

    @Contract(pure=true)
    private int hash2(@NotNull ZbddCache.Operation2 operation, int p1, int p2) {
        return (operation.ordinal() * 0xC00005 + p1 * 4256249 + p2 * 741457 & Integer.MAX_VALUE) % this.slots;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[hits=" + String.format(Locale.US, "%.1f%%", (double)this.lookupHitCount / (double)(this.lookup1Count + this.lookup2Count) * 100.0) + ",capacity=" + String.format(Locale.US, "%.1f%%", (double)(this.cacheElementCount1 + this.cacheElementCount2) / (double)this.capacity * 100.0) + ']';
    }
}

