/*
 * Decompiled with CFR 0.152.
 */
package de.schegge.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@BugPattern(name="ExceptionAsSurprise", severity=BugPattern.SeverityLevel.WARNING, summary="Throwing an Exception in the else statement is much harder to read.")
@AutoService(value={BugChecker.class})
public class ExceptionAsSurprise
extends BugChecker
implements BugChecker.IfTreeMatcher {
    private static final Map<Tree.Kind, String> REVERSE = Map.of(Tree.Kind.LESS_THAN, " >= ", Tree.Kind.LESS_THAN_EQUAL, " > ", Tree.Kind.GREATER_THAN, " <= ", Tree.Kind.GREATER_THAN_EQUAL, " < ", Tree.Kind.EQUAL_TO, " != ", Tree.Kind.NOT_EQUAL_TO, " == ");
    private static final Map<Tree.Kind, String> DE_MORGAN = Map.of(Tree.Kind.AND, " | ", Tree.Kind.OR, " & ", Tree.Kind.CONDITIONAL_OR, " && ", Tree.Kind.CONDITIONAL_AND, " || ");
    private final int maximumThrowBlockLength;

    public ExceptionAsSurprise(ErrorProneFlags flags) {
        this.maximumThrowBlockLength = flags.getInteger("ExceptionAsSurprise:Lines").orElse(3);
    }

    public ExceptionAsSurprise() {
        this.maximumThrowBlockLength = 3;
    }

    public Description matchIf(IfTree tree, VisitorState state) {
        List<? extends StatementTree> statements;
        StatementTree elseStatement = tree.getElseStatement();
        if (elseStatement == null) {
            return Description.NO_MATCH;
        }
        if (elseStatement.getKind() == Tree.Kind.BLOCK ? !(statements = ((BlockTree)elseStatement).getStatements()).isEmpty() && statements.size() <= this.maximumThrowBlockLength && statements.get(statements.size() - 1).getKind() == Tree.Kind.THROW : elseStatement.getKind() == Tree.Kind.THROW) {
            return this.switchThenAndElse(tree, elseStatement, state);
        }
        return Description.NO_MATCH;
    }

    private Description switchThenAndElse(IfTree tree, StatementTree throwTree, VisitorState state) {
        ExpressionTree condition = this.removeParenthesis(tree.getCondition());
        Description.Builder description = this.buildDescription(tree).setLinkUrl("https://schegge.de/2018/04/refactoring-mit-guard-clauses/").addFix((Fix)SuggestedFix.replace((Tree)tree, (String)("if (" + this.invert(condition) + ") {\n" + this.withoutOuterBlock(throwTree, state) + "\n}\n" + this.withoutOuterBlock(tree.getThenStatement(), state))));
        return description.build();
    }

    private String withoutOuterBlock(StatementTree tree, VisitorState state) {
        if (tree.getKind() == Tree.Kind.EMPTY_STATEMENT) {
            return "";
        }
        if (tree.getKind() != Tree.Kind.BLOCK) {
            return state.getSourceForNode((Tree)tree);
        }
        return ((BlockTree)tree).getStatements().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining("\n", "", "\n"));
    }

    private String invert(ExpressionTree condition) {
        if (condition.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
            return ((UnaryTree)condition).getExpression().toString();
        }
        if (condition.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
            return String.valueOf((Boolean)((LiteralTree)condition).getValue() == false);
        }
        String operator = REVERSE.get((Object)condition.getKind());
        if (operator != null) {
            BinaryTree binaryTree = (BinaryTree)condition;
            return String.valueOf(binaryTree.getLeftOperand()) + operator + String.valueOf(binaryTree.getRightOperand());
        }
        operator = DE_MORGAN.get((Object)condition.getKind());
        if (operator != null) {
            BinaryTree binaryTree = (BinaryTree)condition;
            return this.invert(binaryTree.getLeftOperand(), binaryTree.getKind()) + operator + this.invert(binaryTree.getRightOperand(), binaryTree.getKind());
        }
        return this.addComplement(condition);
    }

    private String invert(ExpressionTree condition, Tree.Kind operator) {
        ExpressionTree withoutParenthesis = this.removeParenthesis(condition);
        String result = this.invert(withoutParenthesis);
        if (!(operator != Tree.Kind.OR && operator != Tree.Kind.CONDITIONAL_OR || withoutParenthesis.getKind() != Tree.Kind.AND && withoutParenthesis.getKind() != Tree.Kind.CONDITIONAL_AND)) {
            return "(" + result + ")";
        }
        return result;
    }

    private ExpressionTree removeParenthesis(ExpressionTree ifCondition) {
        ExpressionTree result = ifCondition;
        while (result instanceof ParenthesizedTree) {
            ParenthesizedTree parenthesizedTree = (ParenthesizedTree)result;
            result = parenthesizedTree.getExpression();
        }
        return result;
    }

    private String addComplement(ExpressionTree condition) {
        switch (condition.getKind()) {
            case PARENTHESIZED: 
            case IDENTIFIER: {
                return "!" + String.valueOf(condition);
            }
            case BOOLEAN_LITERAL: {
                return String.valueOf((Boolean)((LiteralTree)condition).getValue() == false);
            }
        }
        return "!(" + String.valueOf(condition) + ")";
    }
}

