/*
 * Decompiled with CFR 0.152.
 */
package de.schegge.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMockChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Name;

@BugPattern(name="SpyOnInterface", summary="A @Spy on an interface is only a @Mock", severity=BugPattern.SeverityLevel.WARNING)
@AutoService(value={BugChecker.class})
public class SpyOnInterface
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final AbstractMockChecker.TypeExtractor<VariableTree> SPIED_VAR = SpyOnInterface.fieldAnnotatedWithOneOf(Stream.of("org.mockito.Spy"));
    private static final String LINK_URL = "https://schegge.de/2021/08/mockito---der-spion-der-mich-hasste/";

    public static AbstractMockChecker.TypeExtractor<VariableTree> fieldAnnotatedWithOneOf(Stream<String> annotationClasses) {
        return SpyOnInterface.extractType(Matchers.allOf((Matcher[])new Matcher[]{Matchers.isField(), Matchers.anyOf((Iterable)annotationClasses.map(Matchers::hasAnnotation).collect(Collectors.toList()))}));
    }

    public static <T extends Tree> AbstractMockChecker.TypeExtractor<T> extractType(Matcher<T> m) {
        return (tree, state) -> m.matches(tree, state) ? Optional.ofNullable(ASTHelpers.getType((Tree)tree)) : Optional.empty();
    }

    public final Description matchVariable(VariableTree tree, VisitorState state) {
        return SPIED_VAR.extract((Tree)tree, state).map(type -> this.checkMockedType((Type)type, tree, state)).orElse(Description.NO_MATCH);
    }

    private Description checkMockedType(Type mockedClass, VariableTree tree, VisitorState state) {
        if (!mockedClass.isInterface() || tree.getInitializer() != null) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree).setLinkUrl(LINK_URL);
        String modifiersWithAnnotations = Objects.requireNonNullElse(state.getSourceForNode((Tree)tree.getModifiers()), "");
        String modifiersWithoutSpy = modifiersWithAnnotations.replace("@org.mockito.Spy", "").replace("@Spy", "");
        String type = state.getSourceForNode(tree.getType());
        Name variable = tree.getName();
        description.addFix((Fix)SuggestedFix.replace((Tree)tree, (String)String.format("@Mock %s %s %s;", modifiersWithoutSpy, type, variable)));
        return description.build();
    }
}

