package de.schegge.holidays;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Map;

import de.schegge.holidays.location.Locode;
import de.schegge.holidays.location.SubDivision;

public interface HolidaysProvider {
	Map<String, DateFunction> create(Locale locale);

	Map<String, DateFunction> create(SubDivision locale);

	Map<String, DateFunction> create(Locode locale);

	Locale getCountry();

	static LocalDate todayOrBefore(DayOfWeek dayOfWeek, LocalDate baseDay) {
		LocalDate day = baseDay.with(dayOfWeek);
		return day.isAfter(baseDay) ? day.minus(7, ChronoUnit.DAYS) : day;
	}

	static LocalDate todayOrAfter(DayOfWeek dayOfWeek, LocalDate baseDay) {
		LocalDate day = baseDay.with(dayOfWeek);
		return day.isAfter(baseDay) ? day : day.plus(7, ChronoUnit.DAYS);
	}
}
