/*
 * Decompiled with CFR 0.152.
 */
package de.schegge.holidays;

import de.schegge.holidays.BackedHolidays;
import de.schegge.holidays.DateFunction;
import de.schegge.holidays.HolidaysProvider;
import de.schegge.holidays.LocalizedHolidays;
import de.schegge.holidays.MapHolidays;
import de.schegge.holidays.location.Locode;
import de.schegge.holidays.location.SubDivision;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;

public abstract class Holidays {
    public static Locale IRELAND = new Locale("en", "IE");
    public static Locale AUSTRIA = new Locale("de", "AT");
    private static Map<String, HolidaysProvider> providers = new HashMap<String, HolidaysProvider>();
    private static Map<Object, MapHolidays> map;

    public abstract boolean isHoliday(LocalDate var1);

    public abstract Map<LocalDate, String> getHolidays(int var1);

    public abstract Optional<String> getHoliday(LocalDate var1);

    public static Holidays in(String country) {
        return Holidays.in(country, Locale.getDefault());
    }

    public static Holidays in(String country, Locale language) {
        return Holidays.in(new Locale(language.getLanguage(), country), language);
    }

    public static Holidays in(Locale locale) {
        return Holidays.in(locale, Locale.getDefault());
    }

    public static Holidays in(Locale locale, Locale language) {
        MapHolidays holidays = map.get(Objects.requireNonNull(locale));
        if (holidays != null) {
            return new LocalizedHolidays(holidays, language);
        }
        return new LocalizedHolidays(Holidays.in(locale, Holidays.getProvider(locale)), language);
    }

    private static MapHolidays in(Locale locale, HolidaysProvider provider) {
        return map.computeIfAbsent(locale, l -> new MapHolidays(provider.create(locale)));
    }

    public static Holidays in(SubDivision subDivision) {
        return Holidays.in(subDivision, Locale.getDefault());
    }

    public static Holidays in(SubDivision subDivision, Locale language) {
        MapHolidays holidays = map.get(Objects.requireNonNull(subDivision));
        if (holidays != null) {
            return new LocalizedHolidays(holidays, language);
        }
        Locale country = subDivision.getCountry();
        return new LocalizedHolidays(Holidays.in(subDivision, country, Holidays.getProvider(country)), language);
    }

    private static MapHolidays in(SubDivision subDivision, Locale country, HolidaysProvider provider) {
        MapHolidays byCountry = Holidays.in(country, provider);
        return map.computeIfAbsent(subDivision, l -> new BackedHolidays(provider.create(subDivision), byCountry));
    }

    public static Holidays in(Locode locode) {
        return Holidays.in(locode, Locale.getDefault());
    }

    public static Holidays in(Locode locode, Locale language) {
        MapHolidays holidays = map.get(Objects.requireNonNull(locode));
        if (holidays != null) {
            return holidays;
        }
        SubDivision subDivision = locode.getSubDivision();
        Locale country = subDivision.getCountry();
        HolidaysProvider provider = Holidays.getProvider(country);
        Map<String, DateFunction> byLocode = provider.create(locode);
        MapHolidays mapHolidays = Holidays.in(subDivision, country, provider);
        if (byLocode.isEmpty()) {
            return new LocalizedHolidays(mapHolidays, language);
        }
        BackedHolidays backedHolidays = new BackedHolidays(byLocode, mapHolidays);
        map.put(locode, backedHolidays);
        return new LocalizedHolidays(backedHolidays, language);
    }

    private static HolidaysProvider getProvider(Locale locale) {
        HolidaysProvider provider = providers.get(locale.getCountry());
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        return provider;
    }

    static {
        ServiceLoader<HolidaysProvider> serviceLoader = ServiceLoader.load(HolidaysProvider.class);
        serviceLoader.forEach(provider -> providers.putIfAbsent(provider.getCountry().getCountry(), (HolidaysProvider)provider));
        map = new HashMap<Object, MapHolidays>();
    }
}

