/*
 * Decompiled with CFR 0.152.
 */
package de.schegge.holidays;

import de.schegge.holidays.Holidays;
import de.schegge.holidays.LocalizedMap;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;

public class LocalizedHolidays
extends Holidays {
    private final Holidays wrapped;
    private final ResourceBundle bundle;

    public LocalizedHolidays(Holidays wrapped, Locale locale) {
        this.wrapped = wrapped;
        this.bundle = ResourceBundle.getBundle("holidays", locale);
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        return this.wrapped.isHoliday(date);
    }

    @Override
    public Map<LocalDate, String> getHolidays(int year) {
        return Collections.unmodifiableMap(new LocalizedMap(this.wrapped.getHolidays(year), this.bundle));
    }

    @Override
    public Optional<String> getHoliday(LocalDate date) {
        return this.wrapped.getHoliday(date).map(this.bundle::getString);
    }
}

