/*
 * Decompiled with CFR 0.152.
 */
package de.schegge.holidays;

import java.time.LocalDate;
import java.util.AbstractMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;

class LocalizedMap
extends AbstractMap<LocalDate, String> {
    private final Map<LocalDate, String> wrapped;
    private final ResourceBundle bundle;

    LocalizedMap(Map<LocalDate, String> wrapped, ResourceBundle bundle) {
        this.wrapped = wrapped;
        this.bundle = bundle;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public String get(Object key) {
        String value = this.wrapped.get(key);
        return value == null ? null : this.bundle.getString(value);
    }

    @Override
    public Set<Map.Entry<LocalDate, String>> entrySet() {
        return this.wrapped.entrySet().stream().map(e -> new LocalizedEntry((LocalDate)e.getKey(), (String)e.getValue())).collect(Collectors.toSet());
    }

    private class LocalizedEntry
    extends AbstractMap.SimpleImmutableEntry<LocalDate, String> {
        private LocalizedEntry(LocalDate key, String value) {
            super(key, value);
        }

        @Override
        public String getValue() {
            return LocalizedMap.this.bundle.getString((String)super.getValue());
        }
    }
}

