/*
 * Decompiled with CFR 0.152.
 */
package de.schegge.holidays;

import de.schegge.holidays.DateFunction;
import de.schegge.holidays.Holidays;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

class MapHolidays
extends Holidays {
    protected final Map<String, DateFunction> functions;

    public MapHolidays(Map<String, DateFunction> functions) {
        this.functions = functions;
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        return this.getHolidays(date.getYear()).containsKey(date);
    }

    @Override
    public Optional<String> getHoliday(LocalDate date) {
        return Optional.ofNullable(this.getHolidays(date.getYear()).get(date));
    }

    @Override
    public Map<LocalDate, String> getHolidays(int year) {
        LinkedHashMap<LocalDate, String> result = new LinkedHashMap<LocalDate, String>();
        for (Map.Entry<String, DateFunction> entry : this.functions.entrySet()) {
            LocalDate key = (LocalDate)entry.getValue().apply(year);
            if (key == null) continue;
            result.put(key, entry.getKey());
        }
        return result;
    }
}

