/*
 * Decompiled with CFR 0.152.
 */
package de.schegge.holidays.freshmarker;

import de.schegge.holidays.Holidays;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.freshmarker.core.ProcessContext;
import org.freshmarker.core.ProcessException;
import org.freshmarker.core.buildin.BuiltIn;
import org.freshmarker.core.buildin.BuiltInKey;
import org.freshmarker.core.buildin.BuiltInKeyBuilder;
import org.freshmarker.core.buildin.FunctionalBuiltIn;
import org.freshmarker.core.model.TemplateObject;
import org.freshmarker.core.model.primitive.TemplateBoolean;
import org.freshmarker.core.model.primitive.TemplateString;
import org.freshmarker.core.model.temporal.TemplateLocalDate;
import org.freshmarker.core.plugin.PluginProvider;

public class HolidayPluginProvider
implements PluginProvider {
    private static final BuiltInKeyBuilder<TemplateLocalDate> DATE_BUILDER = new BuiltInKeyBuilder(TemplateLocalDate.class);

    public void registerBuildIn(Map<BuiltInKey, BuiltIn> builtIns) {
        builtIns.put(DATE_BUILDER.of("get_holiday"), (BuiltIn)new FunctionalBuiltIn((x, y, c) -> {
            Locale locale = this.checkCountry(c.getEnvironment().getLocale());
            TemplateLocalDate value = (TemplateLocalDate)x.evaluate(c, TemplateLocalDate.class);
            return new TemplateString(this.getHolidaysFromStore(c, locale).getHoliday((LocalDate)value.getValue()).orElseGet(() -> this.getOptionalFallback(y)));
        }));
        builtIns.put(DATE_BUILDER.of("is_holiday"), (BuiltIn)new FunctionalBuiltIn((x, y, c) -> {
            Locale locale = this.checkCountry(c.getEnvironment().getLocale());
            TemplateLocalDate value = (TemplateLocalDate)x.evaluate(c, TemplateLocalDate.class);
            return TemplateBoolean.from((boolean)this.getHolidaysFromStore(c, locale).isHoliday((LocalDate)value.getValue()));
        }));
    }

    private Holidays getHolidaysFromStore(ProcessContext c, Locale locale) {
        return (Holidays)c.getStore((Object)"holidays").computeIfAbsent(locale, l -> Holidays.in(locale, locale));
    }

    private String getOptionalFallback(List<TemplateObject> y) {
        if (y.isEmpty()) {
            return "";
        }
        if (y.size() > 1) {
            throw new ProcessException("only one optional parameter allowed");
        }
        return (String)((TemplateString)y.get(0).asString().orElseThrow(() -> new ProcessException("only string constant allowed"))).getValue();
    }

    private Locale checkCountry(Locale locale) {
        if (locale.getCountry() == null) {
            throw new ProcessException("country is missing in locale: " + locale);
        }
        return locale;
    }
}

