/*
 * Decompiled with CFR 0.152.
 */
package de.schegge.holidays.location;

import de.schegge.holidays.location.GermanFederalState;
import de.schegge.holidays.location.Locode;
import java.util.Objects;

public enum GermanLocode implements Locode
{
    AGB("Augsburg", GermanFederalState.BY),
    BFE("Bielefeld", GermanFederalState.NW),
    BOY("Bad Oeynhausen", GermanFederalState.NW);

    private String name;
    private String nameWithoutDiacretics;
    private GermanFederalState subDivision;

    private GermanLocode(String name, GermanFederalState subDivision) {
        this.name = name;
        this.subDivision = subDivision;
        this.nameWithoutDiacretics = name;
    }

    @Override
    public String getLocode() {
        return "DE " + this.name();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameWithoutDiacretics() {
        return this.nameWithoutDiacretics;
    }

    @Override
    public GermanFederalState getSubDivision() {
        return this.subDivision;
    }

    public static GermanLocode byLocode(String locode) {
        return GermanLocode.valueOf(Objects.requireNonNull(locode).substring(3));
    }
}

