/*
 * Decompiled with CFR 0.152.
 */
package de.schegge.holidays.location;

import de.schegge.holidays.location.SubDivision;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public enum UnitedKingdomNation implements SubDivision
{
    EAW("England and Wales"),
    GBN("Great Britain"),
    UKM("United Kingdom");

    private final String name;

    private UnitedKingdomNation(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIso() {
        return "GB-" + this.name();
    }

    @Override
    public Locale getCountry() {
        return Locale.UK;
    }

    public static UnitedKingdomNation byIso(String iso) {
        if (Objects.requireNonNull(iso).length() != 6) {
            throw new IllegalArgumentException();
        }
        String name = iso.substring(3);
        return Arrays.stream(UnitedKingdomNation.values()).filter(value -> value.name().equals(name)).findFirst().orElse(null);
    }
}

