/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.rof;

import de.schlichtherle.io.rof.AbstractReadOnlyFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MemoryMappedReadOnlyFile
extends AbstractReadOnlyFile {
    private static final int WINDOW_LEN = Integer.MAX_VALUE;
    private FileChannel channel;
    private long windowOff = -1L;
    private ByteBuffer window;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MemoryMappedReadOnlyFile(File file) throws FileNotFoundException {
        this.channel = new FileInputStream(file).getChannel();
        try {
            this.window(0L);
        }
        catch (IOException ioe) {
            FileNotFoundException fnfe = new FileNotFoundException(ioe.toString());
            fnfe.initCause(ioe);
            throw fnfe;
        }
        if (!$assertionsDisabled && this.window == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.windowOff != 0L) {
            throw new AssertionError();
        }
    }

    private final int available() throws IOException {
        this.ensureOpen();
        if (this.window.remaining() <= 0) {
            this.window(this.windowOff + Integer.MAX_VALUE);
        }
        return this.window.remaining();
    }

    private void window(long newWindowOff) throws IOException {
        if (this.windowOff == newWindowOff) {
            return;
        }
        long size = this.channel.size();
        if (newWindowOff > size) {
            newWindowOff = size;
        }
        this.window = this.channel.map(FileChannel.MapMode.READ_ONLY, newWindowOff, Math.min(size - newWindowOff, Integer.MAX_VALUE));
        if (!$assertionsDisabled && this.window == null) {
            throw new AssertionError();
        }
        this.windowOff = newWindowOff;
    }

    public long length() throws IOException {
        this.ensureOpen();
        return this.channel.size();
    }

    public long getFilePointer() throws IOException {
        this.ensureOpen();
        return this.windowOff + (long)this.window.position();
    }

    public void seek(long fp) throws IOException {
        this.ensureOpen();
        if (fp < 0L) {
            throw new IOException("file pointer must not be negative");
        }
        long length = this.length();
        if (fp > length) {
            throw new IOException("file pointer (" + fp + ") is larger than file length (" + length + ")");
        }
        this.window(fp / Integer.MAX_VALUE * Integer.MAX_VALUE);
        this.window.position((int)(fp % Integer.MAX_VALUE));
    }

    public int read() throws IOException {
        return this.available() > 0 ? this.window.get() & 0xFF : -1;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > avail) {
            len = avail;
        }
        this.window.get(buf, off, len);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.channel == null) {
            return;
        }
        this.window = null;
        try {
            this.channel.close();
        }
        finally {
            this.channel = null;
            System.gc();
            System.runFinalization();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private final void ensureOpen() throws IOException {
        if (this.channel == null) {
            throw new IOException("file is closed");
        }
    }

    static {
        $assertionsDisabled = !MemoryMappedReadOnlyFile.class.desiredAssertionStatus();
    }
}

