/*
 * Copyright (C) 2006-2010 Schlichtherle IT Services
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.schlichtherle.io;

import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * Thrown if an {@link IOException} happened on the input side rather than
 * the output side when copying an InputStream to an OutputStream.
 * This exception is always initialized with an {@code IOException} as
 * its cause, so it is safe to cast the return value of
 * {@link Throwable#getCause} to an {@code IOException}.
 *
 * @author Christian Schlichtherle
 * @version $Id: InputIOException.java 06f3ba684701 2010/11/04 01:15:55 christian $
 */
// TODO: Review: Rename this to IException?
public class InputIOException extends IOException {

    /**
     * Constructs a new {@code InputIOException}.
     *
     * @param cause A valid {@code IOException}.
     *        This must not be {@code null} and must not be an instance
     *        of {@link FileNotFoundException} (which means that they cannot
     *        not be masked).
     * @throws IllegalArgumentException If {@code cause} is an instance of
     *         {@code FileNotFoundException}.
     */
    public InputIOException(final IOException cause) {
        super(cause != null ? cause.toString() : null);
        if (cause instanceof FileNotFoundException) {
            final IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(cause);
            throw iae;
        }
        super.initCause(cause);
    }
}
