/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io;

import de.schlichtherle.crypto.SeekableBlockCipher;
import de.schlichtherle.io.rof.FilterReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.IOException;
import org.bouncycastle.crypto.Mac;

public abstract class CipherReadOnlyFile
extends FilterReadOnlyFile {
    private static final int MAX_WINDOW_LEN = 1024;
    private long start;
    private long length;
    private long fp;
    private long windowOff;
    private byte[] window;
    private SeekableBlockCipher cipher;
    private long blockOff;
    private byte[] block;
    private boolean closed;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static final long min(long a, long b) {
        return a < b ? a : b;
    }

    public CipherReadOnlyFile(ReadOnlyFile rof) {
        super(rof);
    }

    public void init(SeekableBlockCipher cipher, long start, long length) throws IOException {
        if (this.closed) {
            throw new IOException("file has been closed");
        }
        if (this.cipher != null) {
            throw new IllegalStateException("file is already initialized");
        }
        if (this.rof == null) {
            throw new NullPointerException("rof");
        }
        if (cipher == null) {
            throw new NullPointerException("cipher");
        }
        if (start < 0L || length < 0L) {
            throw new IllegalArgumentException();
        }
        this.cipher = cipher;
        this.start = start;
        this.length = length;
        this.blockOff = length;
        int blockLen = cipher.getBlockSize();
        this.block = new byte[blockLen];
        this.windowOff = Long.MIN_VALUE;
        this.window = new byte[1024 / blockLen * blockLen];
        if (!$assertionsDisabled && this.fp != 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.block.length <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.window.length <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.window.length % this.block.length != 0) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] computeMac(Mac mac) throws IOException {
        int windowLen = this.window.length;
        byte[] buf = new byte[mac.getMacSize()];
        long safedFp = this.getFilePointer();
        try {
            this.fp = 0L;
            while (this.fp < this.length) {
                this.positionWindow();
                long remaining = this.length - this.windowOff;
                mac.update(this.window, 0, (int)CipherReadOnlyFile.min(windowLen, remaining));
                this.fp += (long)windowLen;
            }
            int bufLen = mac.doFinal(buf, 0);
            if (!$assertionsDisabled && bufLen != buf.length) {
                throw new AssertionError();
            }
        }
        finally {
            this.fp = safedFp;
        }
        return buf;
    }

    public long length() throws IOException {
        this.ensureInit();
        return this.length;
    }

    public long getFilePointer() throws IOException {
        this.ensureInit();
        return this.fp;
    }

    public void seek(long fp) throws IOException {
        this.ensureInit();
        if (fp < 0L) {
            throw new IOException("file pointer must not be negative");
        }
        if (fp > this.length) {
            throw new IOException("file pointer (" + fp + ") is larger than file length (" + this.length + ")");
        }
        this.fp = fp;
    }

    public int read() throws IOException {
        this.ensureInit();
        if (this.fp >= this.length) {
            return -1;
        }
        this.positionBlock();
        return this.block[(int)(this.fp++ % (long)this.block.length)] & 0xFF;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        this.ensureInit();
        if (this.fp >= this.length) {
            return -1;
        }
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        int offPlusLen = off + len;
        if ((off | len | offPlusLen | buf.length - offPlusLen) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int blockLen = this.block.length;
        int read = 0;
        int o = (int)(this.fp % (long)blockLen);
        if (o != 0) {
            this.positionBlock();
            read = (int)CipherReadOnlyFile.min(len, blockLen - o);
            read = (int)CipherReadOnlyFile.min(read, this.length - this.fp);
            System.arraycopy(this.block, o, buf, off, read);
            this.fp += (long)read;
        }
        long blockCounter = this.fp / (long)blockLen;
        while (read + blockLen < len && this.fp + (long)blockLen <= this.length) {
            this.positionWindow();
            this.cipher.setBlockCounter(blockCounter++);
            this.cipher.processBlock(this.window, (int)(this.fp - this.windowOff), buf, off + read);
            read += blockLen;
            this.fp += (long)blockLen;
        }
        if (read < len && this.fp < this.length) {
            this.positionBlock();
            int n = (int)CipherReadOnlyFile.min(len - read, this.length - this.fp);
            System.arraycopy(this.block, 0, buf, off + read, n);
            read += n;
            this.fp += (long)n;
        }
        if (!$assertionsDisabled && read <= 0) {
            throw new AssertionError();
        }
        return read;
    }

    private final void ensureInit() throws IOException {
        if (this.cipher == null) {
            throw new IOException("file is closed or not initialized");
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cipher = null;
        this.rof.close();
    }

    private void positionBlock() throws IOException {
        long nextBlockOff;
        long fp = this.fp;
        int blockLen = this.block.length;
        if (this.blockOff <= fp && fp < (nextBlockOff = this.blockOff + (long)blockLen)) {
            return;
        }
        this.positionWindow();
        long blockCounter = fp / (long)blockLen;
        this.blockOff = blockCounter * (long)blockLen;
        this.cipher.setBlockCounter(blockCounter);
        this.cipher.processBlock(this.window, (int)(this.blockOff - this.windowOff), this.block, 0);
    }

    private void positionWindow() throws IOException {
        long fp = this.fp;
        int windowLen = this.window.length;
        long nextWindowOff = this.windowOff + (long)windowLen;
        if (this.windowOff <= fp && fp < nextWindowOff) {
            return;
        }
        try {
            int read;
            int blockLen = this.block.length;
            this.windowOff = fp / (long)blockLen * (long)blockLen;
            if (this.windowOff != nextWindowOff) {
                this.rof.seek(this.windowOff + this.start);
            }
            int n = 0;
            while ((read = this.rof.read(this.window, n, windowLen - n)) >= 0 && (n += read) < windowLen) {
            }
        }
        catch (IOException ioe) {
            this.windowOff = -windowLen - 1;
            throw ioe;
        }
    }

    static {
        $assertionsDisabled = !CipherReadOnlyFile.class.desiredAssertionStatus();
    }
}

