/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.tar.TarDriver;
import de.schlichtherle.io.archive.tar.TarInputArchive;
import de.schlichtherle.io.archive.tar.TarOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class TarBZip2Driver
extends TarDriver {
    private static final long serialVersionUID = 4966248471134003932L;
    private static final int BUFSIZE = 4096;
    public static final int MIN_BLOCKSIZE = 1;
    public static final int MAX_BLOCKSIZE = 9;
    public static final int DEFAULT_BLOCKSIZE = 9;
    public static final int DEFAULT_LEVEL = 9;
    private final int inBlockSize;

    public TarBZip2Driver() {
        this("US-ASCII", null, null, 9);
    }

    public TarBZip2Driver(String charset) {
        this(charset, null, null, 9);
    }

    public TarBZip2Driver(int inBlockSize) {
        this("US-ASCII", null, null, inBlockSize);
    }

    public TarBZip2Driver(String charset, int inBlockSize) {
        this(charset, null, null, inBlockSize);
    }

    public TarBZip2Driver(String charset, Icon openIcon, Icon closedIcon, int inBlockSize) {
        super(charset, openIcon, closedIcon);
        if (inBlockSize < 1 || 9 < inBlockSize) {
            throw new IllegalArgumentException(inBlockSize + "");
        }
        this.inBlockSize = inBlockSize;
    }

    public final int getLevel() {
        return this.inBlockSize;
    }

    protected InputStream createInputStream(Archive archive, ReadOnlyFile rof) throws IOException {
        InputStream in = super.createInputStream(archive, rof);
        if (in.read() != 66 || in.read() != 90) {
            throw new IOException("Not a BZIP2 compressed input stream!");
        }
        byte[] magic = new byte[2];
        InputStream vin = TarInputArchive.readAhead(in, magic);
        if (magic[0] != 104 || magic[1] < 49 || 57 < magic[1]) {
            throw new IOException("Not a BZIP2 compressed input stream!");
        }
        return new CBZip2InputStream((InputStream)new BufferedInputStream(vin, 4096));
    }

    protected TarOutputArchive createTarOutputArchive(Archive archive, OutputStream out, TarInputArchive source) throws IOException {
        out.write(new byte[]{66, 90});
        return super.createTarOutputArchive(archive, (OutputStream)new CBZip2OutputStream((OutputStream)new BufferedOutputStream(out, 4096), this.inBlockSize), source);
    }
}

