/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryName;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.file.FileInputSocket;
import de.schlichtherle.truezip.fs.file.FileOutputSocket;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
class FileEntry
extends FsEntry
implements IOEntry<FileEntry> {
    private static final BitField<FsOutputOption> NO_OUTPUT_OPTIONS = BitField.noneOf(FsOutputOption.class);
    private final File file;
    private final EntryName name;

    FileEntry(File file) {
        assert (null != file);
        this.file = file;
        this.name = EntryName.create((String)file.getName());
    }

    FileEntry(File file, FsEntryName name) {
        assert (null != file);
        this.file = new File(file, name.getPath());
        this.name = name;
    }

    final File getFile() {
        return this.file;
    }

    public final String getName() {
        return this.name.toString();
    }

    public final Set<Entry.Type> getTypes() {
        if (this.file.isFile()) {
            return FILE_TYPE_SET;
        }
        if (this.file.isDirectory()) {
            return DIRECTORY_TYPE_SET;
        }
        if (this.file.exists()) {
            return SPECIAL_TYPE_SET;
        }
        return Collections.EMPTY_SET;
    }

    public final boolean isType(Entry.Type type) {
        switch (type) {
            case FILE: {
                return this.file.isFile();
            }
            case DIRECTORY: {
                return this.file.isDirectory();
            }
            case SPECIAL: {
                return this.file.exists() && !this.file.isFile() && !this.file.isDirectory();
            }
        }
        return false;
    }

    public final long getSize(Entry.Size type) {
        switch (type) {
            case DATA: 
            case STORAGE: {
                return this.file.exists() ? this.file.length() : -1L;
            }
        }
        return -1L;
    }

    public final long getTime(Entry.Access type) {
        return Entry.Access.WRITE == type && this.file.exists() ? this.file.lastModified() : -1L;
    }

    @Nullable
    public final Set<String> getMembers() {
        String[] list = this.file.list();
        return null == list ? null : new HashSet<String>(Arrays.asList(list));
    }

    public final InputSocket<FileEntry> getInputSocket() {
        return new FileInputSocket(this);
    }

    public final OutputSocket<FileEntry> getOutputSocket() {
        return new FileOutputSocket(this, NO_OUTPUT_OPTIONS, null);
    }

    public final OutputSocket<FileEntry> getOutputSocket(BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new FileOutputSocket(this, options, template);
    }
}

