/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.http;

import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.http.HttpController;
import de.schlichtherle.truezip.fs.http.HttpEntry;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;

@Immutable
public class HttpDriver
extends FsDriver {
    private final IOPoolProvider provider;
    @CheckForNull
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private volatile HttpClient client;

    public HttpDriver(IOPoolProvider provider) {
        if (null == provider) {
            throw new NullPointerException();
        }
        this.provider = provider;
    }

    final IOPool<?> getPool() {
        return this.provider.get();
    }

    protected final HttpClient getClient() {
        HttpClient client = this.client;
        return null != client ? client : (this.client = this.newClient());
    }

    protected HttpClient newClient() {
        return new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());
    }

    protected HttpResponse executeHead(HttpEntry entry) throws IOException {
        return this.getClient().execute(entry.newHead());
    }

    protected HttpResponse executeGet(HttpEntry entry) throws IOException {
        return this.getClient().execute(entry.newGet());
    }

    public FsController<?> newController(FsModel model, @CheckForNull FsController<?> parent) {
        assert (null != model.getParent() ? model.getParent().equals((Object)parent.getModel()) : null == parent);
        if (null != parent) {
            throw new IllegalArgumentException();
        }
        return new HttpController(this, model);
    }
}

