/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.http;

import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.http.HttpEntry;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HttpInputSocket
extends InputSocket<HttpEntry> {
    private final HttpEntry entry;

    HttpInputSocket(HttpEntry entry, BitField<FsInputOption> options) {
        assert (null != entry);
        assert (null != options);
        this.entry = entry;
    }

    public HttpEntry getLocalTarget() {
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyFile newReadOnlyFile() throws IOException {
        IOPool.Entry temp;
        InputStream in = this.entry.getInputStream();
        try {
            temp = (IOPool.Entry)this.entry.getPool().allocate();
            try {
                OutputStream out = temp.getOutputSocket().newOutputStream();
                try {
                    Streams.cat((InputStream)in, (OutputStream)out);
                }
                finally {
                    out.close();
                }
            }
            catch (IOException ex) {
                temp.release();
                throw ex;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new InputException((Throwable)ex);
            }
        }
        class TempReadOnlyFile
        extends DecoratingReadOnlyFile {
            boolean closed;

            @CreatesObligation
            @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
            TempReadOnlyFile() throws IOException {
                super(entry.getInputSocket().newReadOnlyFile());
            }

            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                super.close();
                this.closed = true;
                temp.release();
            }
        }
        return new TempReadOnlyFile();
    }

    public InputStream newInputStream() throws IOException {
        return this.entry.getInputStream();
    }
}

